/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.graphics;

import ikor.model.graphics.Shape;
import ikor.model.graphics.Style;

public class Polygon
extends Shape {
    private int[] x;
    private int[] y;

    public Polygon(String id, Style style, Style border, int[] x, int[] y) {
        super(id, style, border);
        this.x = x;
        this.y = y;
    }

    public int getSides() {
        return this.x.length;
    }

    public int[] getXCoords() {
        return this.x;
    }

    public int[] getYCoords() {
        return this.y;
    }

    public int getX(int index) {
        return this.x[index];
    }

    public int getY(int index) {
        return this.y[index];
    }

    public String toString() {
        String str = "p";
        int i = 0;
        while (i < this.x.length) {
            str = String.valueOf(str) + String.format("(%d,%d)", this.x[i], this.y[i]);
            ++i;
        }
        return str;
    }

    @Override
    public int getWidth() {
        return this.getMaxX() - this.getX() + 1;
    }

    @Override
    public int getHeight() {
        return this.getMaxY() - this.getY() + 1;
    }

    @Override
    public int getX() {
        int min = this.x[0];
        int i = 1;
        while (i < this.x.length) {
            if (this.x[i] < min) {
                min = this.x[i];
            }
            ++i;
        }
        return min;
    }

    public int getMaxX() {
        int max = this.x[0];
        int i = 1;
        while (i < this.x.length) {
            if (this.x[i] > max) {
                max = this.x[i];
            }
            ++i;
        }
        return max;
    }

    @Override
    public int getY() {
        int min = this.y[0];
        int i = 1;
        while (i < this.y.length) {
            if (this.y[i] < min) {
                min = this.y[i];
            }
            ++i;
        }
        return min;
    }

    public int getMaxY() {
        int max = this.y[0];
        int i = 1;
        while (i < this.y.length) {
            if (this.y[i] > max) {
                max = this.y[i];
            }
            ++i;
        }
        return max;
    }

    public double area() {
        return Math.abs(this.signedArea());
    }

    public double signedArea() {
        double sum = 0.0;
        int N = this.getSides();
        int i = 0;
        while (i < N) {
            sum = sum + (double)(this.x[i] * this.y[(i + 1) % N]) - (double)(this.y[i] * this.x[(i + 1) % N]);
            ++i;
        }
        return 0.5 * sum;
    }

    public boolean isCCW() {
        return this.signedArea() > 0.0;
    }

    public double getCentroidX() {
        double cx = 0.0;
        int N = this.getSides();
        int i = 0;
        while (i < N) {
            cx += (double)((this.x[i] + this.x[(i + 1) % N]) * (this.y[i] * this.x[(i + 1) % N] - this.x[i] * this.y[(i + 1) % N]));
            ++i;
        }
        return cx / (6.0 * this.area());
    }

    public double getCentroidY() {
        double cy = 0.0;
        int N = this.getSides();
        int i = 0;
        while (i < N) {
            cy += (double)((this.y[i] + this.y[(i + 1) % N]) * (this.y[i] * this.x[(i + 1) % N] - this.x[i] * this.y[(i + 1) % N]));
            ++i;
        }
        return cy / (6.0 * this.area());
    }

    @Override
    public boolean containsPoint(int rx, int ry) {
        double cx = this.getX();
        double cy = this.getY();
        double px = this.getUnrotatedX(cx, cy, rx, ry);
        double py = this.getUnrotatedY(cx, cy, rx, ry);
        if (px >= (double)this.getX() && px <= (double)this.getMaxX() && py >= (double)this.getY() && py <= (double)this.getMaxY()) {
            int crossings = 0;
            int n = this.x.length;
            int i = 0;
            while (i < n) {
                boolean cond3;
                double dy = this.y[(i + 1) % n] - this.y[i];
                double slope = dy != 0.0 ? (double)(this.x[(i + 1) % n] - this.x[i]) / dy : Double.MAX_VALUE;
                boolean cond1 = (double)this.y[i] <= py && py < (double)this.y[(i + 1) % n];
                boolean cond2 = (double)this.y[(i + 1) % n] <= py && py < (double)this.y[i];
                boolean bl = cond3 = px < slope * (py - (double)this.y[i]) + (double)this.x[i];
                if ((cond1 || cond2) && cond3) {
                    ++crossings;
                }
                ++i;
            }
            return crossings % 2 != 0;
        }
        return false;
    }
}

