/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.graphics.charts;

import ikor.math.util.Scale;
import ikor.model.graphics.Line;
import ikor.model.graphics.Renderer;
import ikor.model.graphics.Style;
import ikor.model.graphics.charts.Chart;
import java.awt.Color;

public class AxisRenderer
implements Renderer {
    public static final int MAX_LINES = 100;
    private Chart chart;
    private boolean display = true;
    private int lines = 100;
    private GridStyle gridX = GridStyle.Logarithmic;
    private GridStyle gridY = GridStyle.Logarithmic;
    Style axis;
    Style grid;
    private Scale xscale;
    private Scale yscale;

    public AxisRenderer(Chart chart) {
        this.chart = chart;
        this.axis = new Style(new Color(0, 0, 0, 255), 1);
        this.grid = new Style(new Color(112, 112, 112, 255), 1);
    }

    public void displayAxis(boolean display) {
        this.display = display;
    }

    public void grid(GridStyle x, GridStyle y) {
        this.gridX = x;
        this.gridY = y;
    }

    public void setStyle(Style axis) {
        this.axis = axis;
    }

    public void setGrid(Style grid) {
        this.grid = grid;
    }

    public void setGridLines(int lines) {
        this.lines = lines;
    }

    public Scale getXScale() {
        return this.xscale;
    }

    public void setXScale(Scale xscale) {
        this.xscale = xscale;
    }

    public Scale getYScale() {
        return this.yscale;
    }

    public void setYScale(Scale yscale) {
        this.yscale = yscale;
    }

    @Override
    public void render() {
        double column = 0.75;
        int xspan = (int)((1.0 - column) * (double)this.chart.chartWidth() / (double)this.chart.size());
        if (this.display) {
            this.chart.add(new Line("X Axis", this.axis, this.chart.originX(), this.chart.marginY() + this.chart.chartHeight(), this.chart.originX() + this.chart.chartWidth() + xspan, this.chart.marginY() + this.chart.chartHeight()));
        }
        if (this.gridX == GridStyle.Logarithmic) {
            this.logarithmicGridX();
        } else if (this.gridX == GridStyle.Linear) {
            this.linearGridX();
        }
        if (this.display) {
            this.chart.add(new Line("Y Axis", this.axis, this.chart.originX(), this.chart.marginY() + this.chart.chartHeight(), this.chart.originX(), this.chart.marginY()));
        }
        if (this.gridY == GridStyle.Logarithmic) {
            this.logarithmicGridY();
        } else if (this.gridY == GridStyle.Linear) {
            this.linearGridY();
        }
    }

    private void linearGridX() {
        double range = this.xscale.max() - this.xscale.min();
        double step = range > (double)this.lines ? range / (double)this.lines : 1.0;
        double x = this.xscale.min();
        while (x <= this.xscale.max()) {
            this.chart.add(new Line("x=" + x, this.grid, this.chart.xcoord(this.xscale.scale(x)), this.chart.marginY(), this.chart.xcoord(this.xscale.scale(x)), this.chart.marginY() + this.chart.chartHeight()));
            x += step;
        }
    }

    private void linearGridY() {
        double range = this.yscale.max() - this.yscale.min();
        double step = range > (double)this.lines ? range / (double)this.lines : 1.0;
        double y = this.yscale.min();
        while (y <= this.yscale.max()) {
            this.chart.add(new Line("y=" + y, this.grid, this.chart.originX(), this.chart.ycoord(this.yscale.scale(y)), this.chart.originX() + this.chart.chartWidth(), this.chart.ycoord(this.yscale.scale(y))));
            y += step;
        }
    }

    private void logarithmicGridX() {
        double x = 1.0;
        while (x <= this.xscale.max()) {
            int i = 1;
            while (i < 10 && x * (double)i <= this.xscale.max()) {
                this.chart.add(new Line("x=" + x * (double)i, this.grid, this.chart.xcoord(this.xscale.scale(x * (double)i)), this.chart.marginY(), this.chart.xcoord(this.xscale.scale(x * (double)i)), this.chart.marginY() + this.chart.chartHeight()));
                ++i;
            }
            x *= 10.0;
        }
    }

    private void logarithmicGridY() {
        double y = 1.0;
        while (y <= this.yscale.max()) {
            int i = 1;
            while (i < 10 && y * (double)i <= this.yscale.max()) {
                this.chart.add(new Line("y=" + y * (double)i, this.grid, this.chart.originX(), this.chart.ycoord(this.yscale.scale(y * (double)i)), this.chart.originX() + this.chart.chartWidth(), this.chart.ycoord(this.yscale.scale(y * (double)i))));
                ++i;
            }
            y *= 10.0;
        }
    }

    public static enum GridStyle {
        None,
        Linear,
        Logarithmic;

    }
}

