/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.graphics.charts;

import ikor.math.Vector;
import ikor.model.graphics.Rectangle;
import ikor.model.graphics.Style;
import ikor.model.graphics.charts.Chart;
import ikor.model.graphics.charts.Series;
import ikor.model.graphics.charts.SeriesRenderer;
import ikor.model.graphics.styles.GradientKeyframe;
import ikor.model.graphics.styles.LinearGradient;
import java.awt.Color;

public class BarRenderer
extends SeriesRenderer {
    public static final double DEFAULT_COLUMN_WIDTH = 0.75;
    private Chart chart;
    private Style bar;
    private Style border;
    private double columnWidth = 0.75;
    private double columnOffset = 0.25;

    public BarRenderer(Chart chart, Series series) {
        super(series);
        this.chart = chart;
        LinearGradient gradient = new LinearGradient(0.4f, 0.4f, 0.8f, 0.8f);
        gradient.addKeyframe(new GradientKeyframe(0.0f, new Color(192, 192, 240, 255)));
        gradient.addKeyframe(new GradientKeyframe(1.0f, new Color(0, 0, 176, 255)));
        gradient.setWidth(10);
        this.bar = gradient;
        this.border = new Style(new Color(51, 0, 0, 255), 1);
    }

    public BarRenderer(Chart chart, Vector data) {
        this(chart, new Series(data));
    }

    public void setBorder(Style border) {
        this.border = border;
    }

    public void setStyle(Style bar) {
        this.bar = bar;
    }

    public void setColumnWidth(double width) {
        this.columnWidth = width;
    }

    public void setColumnOffset(double offset) {
        this.columnOffset = offset;
    }

    @Override
    public void render(int i) {
        int xspan = this.chart.chartWidth() / this.getSeries().size();
        int x = this.chart.originX(i) + (int)((double)xspan * this.columnOffset);
        int y = (int)((double)this.chart.marginY() + (double)this.chart.chartHeight() * (1.0 - this.yscale(i)));
        int width = (int)(this.columnWidth * (double)xspan);
        int height = (int)((double)this.chart.chartHeight() * this.yscale(i));
        this.chart.add(new Rectangle(this.label(i), this.bar, this.border, x, y, width, height));
    }
}

