/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.graphics.charts;

import ikor.collection.DynamicList;
import ikor.collection.List;
import ikor.math.Vector;
import ikor.math.util.Scale;
import ikor.model.graphics.Drawing;
import ikor.model.graphics.charts.AxisRenderer;
import ikor.model.graphics.charts.BackgroundRenderer;
import ikor.model.graphics.charts.Series;
import ikor.model.graphics.charts.SeriesRenderer;
import java.lang.reflect.Constructor;

public class Chart
extends Drawing {
    private List<Series> data = new DynamicList<Series>();
    private List<SeriesRenderer> renderers = new DynamicList<SeriesRenderer>();
    private BackgroundRenderer background = new BackgroundRenderer(this);
    private AxisRenderer axis = new AxisRenderer(this);
    public static final double DEFAULT_MARGIN = 0.05;
    private double margin = 0.05;

    public Chart(int width, int height) {
        super(width, height);
    }

    @Override
    public void clear() {
        super.clear();
        this.data.clear();
        this.renderers.clear();
    }

    public SeriesRenderer createRenderer(Series series, Class type) {
        SeriesRenderer renderer = null;
        try {
            Class[] constructorArguments = new Class[]{Chart.class, Series.class};
            Constructor constructor = type.getDeclaredConstructor(constructorArguments);
            Object[] arguments = new Object[]{this, series};
            renderer = (SeriesRenderer)constructor.newInstance(arguments);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return renderer;
    }

    public void addSeries(Series series, SeriesRenderer renderer) {
        this.data.add(series);
        this.renderers.add(renderer);
        if (this.data.size() == 1) {
            this.axis.setXScale(renderer.getXScale());
            this.axis.setYScale(renderer.getYScale());
        }
    }

    public void addSeries(Series series, Class type) {
        this.addSeries(series, this.createRenderer(series, type));
    }

    public void addSeries(String id, Vector data, Class type) {
        this.addSeries(new Series(id, data), type);
    }

    public void addSeries(Vector data, Class type) {
        this.addSeries("Series " + this.series(), data, type);
    }

    public void addSeries(String id, Vector data, SeriesRenderer renderer) {
        this.addSeries(new Series(id, data), renderer);
    }

    public void addSeries(Vector data, SeriesRenderer renderer) {
        this.addSeries("Series " + this.series(), data, renderer);
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double newMargin) {
        this.margin = newMargin;
    }

    public int marginX() {
        return (int)(this.getMargin() * (double)this.chartWidth());
    }

    public int marginY() {
        return (int)(this.getMargin() * (double)this.chartHeight());
    }

    public int chartWidth() {
        return (int)((double)this.getWidth() * (1.0 - 2.0 * this.getMargin()));
    }

    public int chartHeight() {
        return (int)((double)this.getHeight() * (1.0 - 2.0 * this.getMargin()));
    }

    public int originX() {
        return this.marginX();
    }

    public int originX(int i) {
        return this.marginX() + i * this.chartWidth() / this.size();
    }

    public int series() {
        return this.data.size();
    }

    public int size() {
        if (this.data.size() > 0) {
            return ((Series)this.data.get(0)).size();
        }
        return 0;
    }

    public Series getSeries(int i) {
        return (Series)this.data.get(i);
    }

    public void setSeries(int i, Series series) {
        this.data.set(i, series);
    }

    public void removeSeries(int i) {
        this.data.remove(i);
        this.renderers.remove(i);
    }

    public Scale getXScale(int i) {
        return ((SeriesRenderer)this.renderers.get(i)).getXScale();
    }

    public void setXScale(int i, Scale xscale) {
        ((SeriesRenderer)this.renderers.get(i)).setXScale(xscale);
    }

    public void setXScale(Scale xscale) {
        int i = 0;
        while (i < this.series()) {
            this.setXScale(i, xscale);
            ++i;
        }
        this.axis.setXScale(xscale);
    }

    public Scale getYScale(int i) {
        return ((SeriesRenderer)this.renderers.get(i)).getYScale();
    }

    public void setYScale(int i, Scale yscale) {
        ((SeriesRenderer)this.renderers.get(i)).setYScale(yscale);
    }

    public void setYScale(Scale yscale) {
        int i = 0;
        while (i < this.series()) {
            this.setYScale(i, yscale);
            ++i;
        }
        this.axis.setYScale(yscale);
    }

    public int ycoord(double value) {
        return (int)((double)(this.marginY() + this.chartHeight()) - value * (double)this.chartHeight());
    }

    public int xcoord(double value) {
        return (int)((double)this.marginX() + value * (double)this.chartWidth());
    }

    public BackgroundRenderer getBackgroundRenderer() {
        return this.background;
    }

    public void setBackgroundRenderer(BackgroundRenderer renderer) {
        this.background = renderer;
    }

    public AxisRenderer getAxisRenderer() {
        return this.axis;
    }

    public void setAxisRenderer(AxisRenderer renderer) {
        this.axis = renderer;
    }

    public SeriesRenderer getRenderer(int i) {
        return (SeriesRenderer)this.renderers.get(i);
    }

    public void setRenderer(int i, SeriesRenderer renderer) {
        this.renderers.set(i, renderer);
    }

    @Override
    public void update() {
        this.render();
    }

    public void render() {
        super.clear();
        if (this.background != null) {
            this.background.render();
        }
        if (this.axis != null) {
            this.axis.render();
        }
        int i = 0;
        while (i < this.renderers.size()) {
            ((SeriesRenderer)this.renderers.get(i)).render();
            ++i;
        }
    }
}

