/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.graphics.charts;

import ikor.math.Vector;
import ikor.math.util.LinearScale;
import ikor.math.util.Scale;
import ikor.model.graphics.Renderer;
import ikor.model.graphics.charts.Series;

public abstract class SeriesRenderer
implements Renderer {
    private Series series;
    private Scale xscale;
    private Scale yscale;

    public SeriesRenderer(Series series) {
        this.series = series;
        this.xscale = series.getX() == null ? new LinearScale(0.0, series.size() - 1) : new LinearScale(series.getX().min(), series.getX().max());
        this.yscale = new LinearScale(series.getY().min(), series.getY().max());
    }

    public SeriesRenderer(Vector data) {
        this(new Series(data));
    }

    public Series getSeries() {
        return this.series;
    }

    public Scale getXScale() {
        return this.xscale;
    }

    public void setXScale(Scale xscale) {
        this.xscale = xscale;
    }

    public Scale getYScale() {
        return this.yscale;
    }

    public void setYScale(Scale yscale) {
        this.yscale = yscale;
    }

    public double xscale(int index) {
        return this.xscale.scale(this.series.getX(index));
    }

    public double yscale(int index) {
        return this.yscale.scale(this.series.getY(index));
    }

    protected String label(int i) {
        return String.valueOf(this.series.id()) + "[" + i + "]";
    }

    @Override
    public void render() {
        int i = 0;
        while (i < this.series.size()) {
            this.render(i);
            ++i;
        }
    }

    public abstract void render(int var1);
}

