/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.graphics.colors;

import ikor.model.graphics.colors.ColorMap;

public class GrayscaleColorMap
extends ColorMap {
    private int size;
    private double gamma;
    public static final double DEFAULT_GAMMA = 2.0;

    public GrayscaleColorMap(int size) {
        this.size = size;
        this.gamma = 2.0;
    }

    public GrayscaleColorMap(int size, double gamma) {
        this.size = size;
        this.gamma = gamma;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int gray(int index) {
        return (int)(255.0 * Math.pow((double)index / (double)this.size, 1.0 / this.gamma));
    }

    @Override
    public int red(int index) {
        return this.gray(index);
    }

    @Override
    public int green(int index) {
        return this.gray(index);
    }

    @Override
    public int blue(int index) {
        return this.gray(index);
    }
}

