/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.graphics.colors;

import ikor.model.graphics.colors.ColorMap;
import java.util.Arrays;

public class JetColorMap
extends ColorMap {
    private int[] r;
    private int[] g;
    private int[] b;

    public JetColorMap(int size) {
        this.r = new int[size];
        this.g = new int[size];
        this.b = new int[size];
        this.createJet(size);
    }

    private void createJet(int n) {
        int maxval = 255;
        Arrays.fill(this.g, 0, n / 8, 0);
        int x = 0;
        while (x < n / 4) {
            this.g[x + n / 8] = maxval * x * 4 / n;
            ++x;
        }
        Arrays.fill(this.g, n * 3 / 8, n * 5 / 8, maxval);
        x = 0;
        while (x < n / 4) {
            this.g[x + n * 5 / 8] = maxval - maxval * x * 4 / n;
            ++x;
        }
        Arrays.fill(this.g, n * 7 / 8, n, 0);
        x = 0;
        while (x < this.g.length) {
            this.b[x] = this.g[(x + n / 4) % this.g.length];
            ++x;
        }
        Arrays.fill(this.b, n * 7 / 8, n, 0);
        Arrays.fill(this.g, 0, n / 8, 0);
        x = n / 8;
        while (x < this.g.length) {
            this.r[x] = this.g[(x + n * 6 / 8) % this.g.length];
            ++x;
        }
    }

    @Override
    public int size() {
        return this.r.length;
    }

    @Override
    public int red(int index) {
        return this.r[index];
    }

    @Override
    public int green(int index) {
        return this.g[index];
    }

    @Override
    public int blue(int index) {
        return this.b[index];
    }
}

