/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.graphics.io;

import ikor.collection.Dictionary;
import ikor.collection.DynamicDictionary;
import ikor.model.graphics.Arc;
import ikor.model.graphics.Bitmap;
import ikor.model.graphics.Circle;
import ikor.model.graphics.Drawing;
import ikor.model.graphics.DrawingElement;
import ikor.model.graphics.Ellipse;
import ikor.model.graphics.Line;
import ikor.model.graphics.Polygon;
import ikor.model.graphics.Rectangle;
import ikor.model.graphics.Style;
import ikor.model.graphics.Text;
import ikor.model.graphics.io.DrawingWriter;
import ikor.model.graphics.styles.FontStyle;
import ikor.model.graphics.styles.Gradient;
import ikor.model.graphics.styles.GradientKeyframe;
import ikor.model.graphics.styles.LinearGradient;
import ikor.model.graphics.styles.RadialGradient;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Locale;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SVGDrawingWriter
extends DrawingWriter {
    Dictionary<Class, SVGStyleWriter> styleWriters = new DynamicDictionary<Class, SVGStyleWriter>();
    Dictionary<Class, SVGElementWriter> elementWriters;

    public SVGDrawingWriter(Drawing drawing) {
        super(drawing);
        this.styleWriters.set(FontStyle.class, null);
        this.styleWriters.set(LinearGradient.class, new SVGLinearGradientWriter());
        this.styleWriters.set(RadialGradient.class, new SVGRadialGradientWriter());
        this.styleWriters.set(Style.class, null);
        this.elementWriters = new DynamicDictionary<Class, SVGElementWriter>();
        this.elementWriters.set(Line.class, new SVGLineWriter());
        this.elementWriters.set(Rectangle.class, new SVGRectangleWriter());
        this.elementWriters.set(Polygon.class, new SVGPolygonWriter());
        this.elementWriters.set(Circle.class, new SVGCircleWriter());
        this.elementWriters.set(Ellipse.class, new SVGEllipseWriter());
        this.elementWriters.set(Arc.class, new SVGArcWriter());
        this.elementWriters.set(Bitmap.class, new SVGBitmapWriter());
        this.elementWriters.set(Text.class, new SVGTextWriter());
    }

    @Override
    public void write(OutputStream writer) throws IOException {
        BufferedWriter output = new BufferedWriter(new OutputStreamWriter(writer));
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            XMLStreamWriter xmlWriter = factory.createXMLStreamWriter(output);
            xmlWriter.writeStartDocument("ISO-8859-1", "1.0");
            xmlWriter.writeStartElement("svg");
            xmlWriter.writeAttribute("xmlns", "http://www.w3.org/2000/svg");
            xmlWriter.writeAttribute("version", "1.1");
            xmlWriter.writeAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
            this.writeStyles(xmlWriter);
            this.writeElements(xmlWriter);
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
            xmlWriter.flush();
            xmlWriter.close();
        }
        catch (XMLStreamException error) {
            throw new IOException(error);
        }
    }

    private void writeStyles(XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeStartElement("defs");
        for (Style style : this.drawing.getStyles()) {
            this.writeStyle(style, xmlWriter);
        }
        xmlWriter.writeEndElement();
    }

    private void writeStyle(Style style, XMLStreamWriter xmlWriter) throws XMLStreamException {
        SVGStyleWriter writer = this.getStyleWriter(style.getClass());
        if (writer != null) {
            writer.write(style, xmlWriter);
        }
    }

    public SVGStyleWriter getStyleWriter(Class type) {
        SVGStyleWriter writer = (SVGStyleWriter)this.styleWriters.get(type);
        if (writer != null) {
            return writer;
        }
        if (type.getSuperclass() != null) {
            return this.getStyleWriter(type.getSuperclass());
        }
        return null;
    }

    private void writeElements(XMLStreamWriter xmlWriter) throws XMLStreamException {
        for (DrawingElement element : this.drawing.getElements()) {
            this.writeElement(element, xmlWriter);
        }
    }

    private void writeElement(DrawingElement element, XMLStreamWriter xmlWriter) throws XMLStreamException {
        SVGElementWriter writer = this.getElementWriter(element.getClass());
        if (writer != null) {
            writer.write(element, xmlWriter);
        }
    }

    public SVGElementWriter getElementWriter(Class type) {
        SVGElementWriter writer = (SVGElementWriter)this.elementWriters.get(type);
        if (writer != null) {
            return writer;
        }
        if (type.getSuperclass() != null) {
            return this.getElementWriter(type.getSuperclass());
        }
        return null;
    }

    public String rgbColor(Color color) {
        return String.format("#%06x", color.getRGB() & 0xFFFFFF);
    }

    public String opacity(Color color) {
        return String.format(Locale.ENGLISH, "%.3f", (double)(color.getRGB() >>> 24) / 255.0);
    }

    private class SVGArcWriter
    extends SVGElementWriter {
        private SVGArcWriter() {
        }

        @Override
        public void write(DrawingElement element, XMLStreamWriter writer) throws XMLStreamException {
            Arc arc = (Arc)element;
            int sx = (int)((double)arc.getCenterX() + Math.cos(arc.getStartAngle()) * (double)arc.getRadiusX());
            int sy = (int)((double)arc.getCenterY() - Math.sin(arc.getStartAngle()) * (double)arc.getRadiusY());
            int dx = (int)((double)arc.getCenterX() + Math.cos(arc.getEndAngle()) * (double)arc.getRadiusX());
            int dy = (int)((double)arc.getCenterY() - Math.sin(arc.getEndAngle()) * (double)arc.getRadiusY());
            writer.writeStartElement("path");
            if (arc.getId() != null) {
                writer.writeAttribute("id", arc.getId());
            }
            writer.writeAttribute("d", "M " + arc.getCenterX() + " " + arc.getCenterY() + " " + "L " + sx + " " + sy + " " + "A " + arc.getRadiusX() + " " + arc.getRadiusY() + " " + "0 " + (arc.getExtent() >= Math.PI ? "1 " : "0 ") + (arc.getStartAngle() < arc.getEndAngle() ? "0 " : "1 ") + dx + " " + dy + " " + "L " + arc.getCenterX() + " " + arc.getCenterY());
            if (arc.getRotation() != 0.0) {
                writer.writeAttribute("transform", "rotate(" + (int)(180.0 * arc.getRotation() / Math.PI) + " " + arc.getCenterX() + "," + arc.getCenterY() + ")");
            }
            if (this.styleReference(arc.getStyle()) != null) {
                writer.writeAttribute("fill", this.styleReference(arc.getStyle()));
            }
            if (this.styleReference(arc.getBorder()) != null) {
                writer.writeAttribute("stroke", this.styleReference(arc.getBorder()));
            }
            writer.writeAttribute("style", this.styleString(arc.getStyle(), arc.getBorder()));
            writer.writeEndElement();
        }
    }

    private class SVGBitmapWriter
    extends SVGElementWriter {
        private SVGBitmapWriter() {
        }

        @Override
        public void write(DrawingElement element, XMLStreamWriter writer) throws XMLStreamException {
            Bitmap image = (Bitmap)element;
            writer.writeStartElement("image");
            if (image.getId() != null) {
                writer.writeAttribute("id", image.getId());
            }
            writer.writeAttribute("x", "" + image.getX());
            writer.writeAttribute("y", "" + image.getY());
            writer.writeAttribute("height", "" + image.getHeight());
            writer.writeAttribute("width", "" + image.getWidth());
            writer.writeAttribute("href", image.getUrl());
            writer.writeEndElement();
        }
    }

    private class SVGCircleWriter
    extends SVGElementWriter {
        private SVGCircleWriter() {
        }

        @Override
        public void write(DrawingElement element, XMLStreamWriter writer) throws XMLStreamException {
            Circle circle = (Circle)element;
            writer.writeStartElement("circle");
            if (circle.getId() != null) {
                writer.writeAttribute("id", circle.getId());
            }
            writer.writeAttribute("cx", "" + circle.getCenterX());
            writer.writeAttribute("cy", "" + circle.getCenterY());
            writer.writeAttribute("r", "" + circle.getRadius());
            if (this.styleReference(circle.getStyle()) != null) {
                writer.writeAttribute("fill", this.styleReference(circle.getStyle()));
            }
            if (this.styleReference(circle.getBorder()) != null) {
                writer.writeAttribute("stroke", this.styleReference(circle.getBorder()));
            }
            writer.writeAttribute("style", this.styleString(circle.getStyle(), circle.getBorder()));
            writer.writeEndElement();
        }
    }

    private abstract class SVGElementWriter {
        private SVGElementWriter() {
        }

        public abstract void write(DrawingElement var1, XMLStreamWriter var2) throws XMLStreamException;

        public String styleReference(Style style) {
            if (style != null && style instanceof Gradient) {
                return "url(#s" + style.hashCode() + ")";
            }
            return null;
        }

        public String fillString(Style style) {
            return "fill:" + SVGDrawingWriter.this.rgbColor(style.getColor()) + ";" + "fill-opacity:" + SVGDrawingWriter.this.opacity(style.getColor()) + ";";
        }

        public String borderString(Style style) {
            return "stroke:" + SVGDrawingWriter.this.rgbColor(style.getColor()) + ";" + "stroke-opacity:" + SVGDrawingWriter.this.opacity(style.getColor()) + ";" + "stroke-width:" + style.getWidth() + ";";
        }

        public String styleString(Style fill, Style border) {
            String result = "";
            if (fill != null && this.styleReference(fill) == null) {
                result = String.valueOf(result) + this.fillString(fill);
            }
            if (border != null && this.styleReference(border) == null) {
                result = String.valueOf(result) + this.borderString(border);
            }
            return result;
        }
    }

    private class SVGEllipseWriter
    extends SVGElementWriter {
        private SVGEllipseWriter() {
        }

        @Override
        public void write(DrawingElement element, XMLStreamWriter writer) throws XMLStreamException {
            Ellipse ellipse = (Ellipse)element;
            writer.writeStartElement("ellipse");
            if (ellipse.getId() != null) {
                writer.writeAttribute("id", ellipse.getId());
            }
            writer.writeAttribute("cx", "" + ellipse.getCenterX());
            writer.writeAttribute("cy", "" + ellipse.getCenterY());
            writer.writeAttribute("rx", "" + ellipse.getRadiusX());
            writer.writeAttribute("ry", "" + ellipse.getRadiusY());
            if (ellipse.getRotation() != 0.0) {
                writer.writeAttribute("transform", "rotate(" + (int)(180.0 * ellipse.getRotation() / Math.PI) + " " + ellipse.getCenterX() + "," + ellipse.getCenterY() + ")");
            }
            if (this.styleReference(ellipse.getStyle()) != null) {
                writer.writeAttribute("fill", this.styleReference(ellipse.getStyle()));
            }
            if (this.styleReference(ellipse.getBorder()) != null) {
                writer.writeAttribute("stroke", this.styleReference(ellipse.getBorder()));
            }
            writer.writeAttribute("style", this.styleString(ellipse.getStyle(), ellipse.getBorder()));
            writer.writeEndElement();
        }
    }

    private class SVGLineWriter
    extends SVGElementWriter {
        private SVGLineWriter() {
        }

        @Override
        public void write(DrawingElement element, XMLStreamWriter writer) throws XMLStreamException {
            Line line = (Line)element;
            writer.writeStartElement("line");
            if (line.getId() != null) {
                writer.writeAttribute("id", line.getId());
            }
            writer.writeAttribute("x1", "" + line.getStartX());
            writer.writeAttribute("y1", "" + line.getStartY());
            writer.writeAttribute("x2", "" + line.getEndX());
            writer.writeAttribute("y2", "" + line.getEndY());
            writer.writeAttribute("style", this.borderString(line.getStyle()));
            writer.writeEndElement();
        }
    }

    private class SVGLinearGradientWriter
    extends SVGStyleWriter {
        private SVGLinearGradientWriter() {
        }

        @Override
        public void write(Style style, XMLStreamWriter writer) throws XMLStreamException {
            LinearGradient gradient = (LinearGradient)style;
            writer.writeStartElement("linearGradient");
            writer.writeAttribute("id", "s" + gradient.hashCode());
            writer.writeAttribute("x1", Math.round(100.0f * gradient.getStartX()) + "%");
            writer.writeAttribute("y1", Math.round(100.0f * gradient.getStartY()) + "%");
            writer.writeAttribute("x2", Math.round(100.0f * gradient.getEndX()) + "%");
            writer.writeAttribute("y2", Math.round(100.0f * gradient.getEndY()) + "%");
            for (GradientKeyframe keyframe : gradient.getKeyframes()) {
                writer.writeStartElement("stop");
                writer.writeAttribute("offset", Math.round(100.0f * keyframe.getValue()) + "%");
                writer.writeAttribute("style", "stop-color:" + SVGDrawingWriter.this.rgbColor(keyframe.getColor()) + ";" + "stop-opacity:" + SVGDrawingWriter.this.opacity(keyframe.getColor()));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private class SVGPolygonWriter
    extends SVGElementWriter {
        private SVGPolygonWriter() {
        }

        @Override
        public void write(DrawingElement element, XMLStreamWriter writer) throws XMLStreamException {
            Polygon polygon = (Polygon)element;
            writer.writeStartElement("polygon");
            if (polygon.getId() != null) {
                writer.writeAttribute("id", polygon.getId());
            }
            String coordinates = "";
            int i = 0;
            while (i < polygon.getSides()) {
                coordinates = String.valueOf(coordinates) + polygon.getX(i) + "," + polygon.getY(i) + " ";
                ++i;
            }
            writer.writeAttribute("points", coordinates);
            if (polygon.getRotation() != 0.0) {
                writer.writeAttribute("transform", "rotate(" + (int)(180.0 * polygon.getRotation() / Math.PI) + " " + polygon.getX() + "," + polygon.getY() + ")");
            }
            if (this.styleReference(polygon.getStyle()) != null) {
                writer.writeAttribute("fill", this.styleReference(polygon.getStyle()));
            }
            if (this.styleReference(polygon.getBorder()) != null) {
                writer.writeAttribute("stroke", this.styleReference(polygon.getBorder()));
            }
            writer.writeAttribute("style", this.styleString(polygon.getStyle(), polygon.getBorder()));
            writer.writeEndElement();
        }
    }

    private class SVGRadialGradientWriter
    extends SVGStyleWriter {
        private SVGRadialGradientWriter() {
        }

        @Override
        public void write(Style style, XMLStreamWriter writer) throws XMLStreamException {
            RadialGradient gradient = (RadialGradient)style;
            writer.writeStartElement("radialGradient");
            writer.writeAttribute("id", "s" + gradient.hashCode());
            writer.writeAttribute("cx", Math.round(100.0f * gradient.getCenterX()) + "%");
            writer.writeAttribute("cy", Math.round(100.0f * gradient.getCenterY()) + "%");
            writer.writeAttribute("r", Math.round(100.0f * gradient.getRadius()) + "%");
            writer.writeAttribute("fx", Math.round(100.0f * gradient.getCenterX()) + "%");
            writer.writeAttribute("fy", Math.round(100.0f * gradient.getCenterY()) + "%");
            for (GradientKeyframe keyframe : gradient.getKeyframes()) {
                writer.writeStartElement("stop");
                writer.writeAttribute("offset", Math.round(100.0f * keyframe.getValue()) + "%");
                writer.writeAttribute("style", "stop-color:" + SVGDrawingWriter.this.rgbColor(keyframe.getColor()) + ";" + "stop-opacity:" + SVGDrawingWriter.this.opacity(keyframe.getColor()));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private class SVGRectangleWriter
    extends SVGElementWriter {
        private SVGRectangleWriter() {
        }

        @Override
        public void write(DrawingElement element, XMLStreamWriter writer) throws XMLStreamException {
            Rectangle rectangle = (Rectangle)element;
            writer.writeStartElement("rect");
            if (rectangle.getId() != null) {
                writer.writeAttribute("id", rectangle.getId());
            }
            writer.writeAttribute("x", "" + rectangle.getX());
            writer.writeAttribute("y", "" + rectangle.getY());
            writer.writeAttribute("width", "" + rectangle.getWidth());
            writer.writeAttribute("height", "" + rectangle.getHeight());
            if (rectangle.getRotation() != 0.0) {
                writer.writeAttribute("transform", "rotate(" + (int)(180.0 * rectangle.getRotation() / Math.PI) + " " + rectangle.getX() + "," + rectangle.getY() + ")");
            }
            if (this.styleReference(rectangle.getStyle()) != null) {
                writer.writeAttribute("fill", this.styleReference(rectangle.getStyle()));
            }
            if (this.styleReference(rectangle.getBorder()) != null) {
                writer.writeAttribute("stroke", this.styleReference(rectangle.getBorder()));
            }
            writer.writeAttribute("style", this.styleString(rectangle.getStyle(), rectangle.getBorder()));
            writer.writeEndElement();
        }
    }

    private abstract class SVGStyleWriter {
        private SVGStyleWriter() {
        }

        public abstract void write(Style var1, XMLStreamWriter var2) throws XMLStreamException;
    }

    private class SVGTextWriter
    extends SVGElementWriter {
        private SVGTextWriter() {
        }

        @Override
        public void write(DrawingElement element, XMLStreamWriter writer) throws XMLStreamException {
            Text text = (Text)element;
            writer.writeStartElement("text");
            if (text.getId() != null) {
                writer.writeAttribute("id", text.getId());
            }
            writer.writeAttribute("x", "" + text.getX());
            writer.writeAttribute("y", "" + text.getY());
            if (this.styleReference(text.getStyle()) != null) {
                writer.writeAttribute("fill", this.styleReference(text.getStyle()));
            }
            if (this.styleReference(text.getBorder()) != null) {
                writer.writeAttribute("stroke", this.styleReference(text.getBorder()));
            }
            if (text.getStyle() instanceof FontStyle) {
                FontStyle font = (FontStyle)text.getStyle();
                writer.writeAttribute("font-family", font.getFont().getFamily());
                writer.writeAttribute("font-size", "" + font.getFont().getSize());
                if (font.getAngle() != 0.0) {
                    writer.writeAttribute("transform", "rotate(" + (int)(180.0 * font.getAngle() / Math.PI) + " " + text.getX() + "," + text.getY() + ")");
                }
            }
            writer.writeAttribute("style", this.styleString(text.getStyle(), text.getBorder()));
            writer.writeCharacters(text.getText());
            writer.writeEndElement();
        }
    }
}

