/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.graphics.swing;

import ikor.collection.Dictionary;
import ikor.collection.DynamicDictionary;
import ikor.model.graphics.Arc;
import ikor.model.graphics.Bitmap;
import ikor.model.graphics.Circle;
import ikor.model.graphics.Drawing;
import ikor.model.graphics.DrawingElement;
import ikor.model.graphics.DrawingSelectionListener;
import ikor.model.graphics.DrawingTooltipProvider;
import ikor.model.graphics.DrawingUpdateListener;
import ikor.model.graphics.Ellipse;
import ikor.model.graphics.Line;
import ikor.model.graphics.Polygon;
import ikor.model.graphics.Rectangle;
import ikor.model.graphics.Style;
import ikor.model.graphics.Text;
import ikor.model.graphics.styles.FontStyle;
import ikor.model.graphics.styles.LinearGradient;
import ikor.model.graphics.styles.RadialGradient;
import ikor.model.graphics.swing.JDrawingMouseListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class JDrawingComponent
extends JComponent {
    private Drawing drawing;
    private DrawingTooltipProvider tooltipProvider;
    private DrawingSelectionListener selectionListener;
    private DrawingUpdateListener actionListener;
    private DrawingUpdateListener draggingListener;
    private Dictionary<String, Image> images;

    public JDrawingComponent(Drawing drawing) {
        this.drawing = drawing;
        this.images = new DynamicDictionary<String, Image>();
        this.setPreferredSize(new Dimension(drawing.getWidth(), drawing.getHeight()));
        JDrawingMouseListener mouseListener = new JDrawingMouseListener(this);
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
    }

    public Drawing getDrawing() {
        return this.drawing;
    }

    public void setDrawing(Drawing drawing) {
        this.drawing = drawing;
    }

    public void save(String fileName, String format) {
        java.awt.Rectangle r = this.getBounds();
        try {
            BufferedImage img = new BufferedImage(r.width, r.height, 1);
            Graphics g = img.getGraphics();
            this.paint(g);
            ImageIO.write((RenderedImage)img, format, new File(fileName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save(OutputStream writer, String format) {
        java.awt.Rectangle r = this.getBounds();
        try {
            BufferedImage img = new BufferedImage(r.width, r.height, 1);
            Graphics g = img.getGraphics();
            this.paint(g);
            ImageIO.write((RenderedImage)img, format, writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (!this.isOpaque()) {
            g2.setColor(this.getBackground());
            g2.fillRect(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height);
        }
        for (DrawingElement element : this.drawing.getElements()) {
            this.draw(g2, element);
        }
    }

    public void draw(Graphics2D g, DrawingElement element) {
        if (element instanceof Line) {
            this.drawLine(g, (Line)element);
        } else if (element instanceof Rectangle) {
            this.drawRectangle(g, (Rectangle)element);
        } else if (element instanceof Polygon) {
            this.drawPolygon(g, (Polygon)element);
        } else if (element instanceof Circle) {
            this.drawCircle(g, (Circle)element);
        } else if (element instanceof Arc) {
            this.drawArc(g, (Arc)element);
        } else if (element instanceof Ellipse) {
            this.drawEllipse(g, (Ellipse)element);
        } else if (element instanceof Bitmap) {
            this.drawBitmap(g, (Bitmap)element);
        } else if (element instanceof Text) {
            this.drawText(g, (Text)element);
        }
    }

    public void drawLine(Graphics2D g, Line line) {
        this.setStyle(g, line, line.getStyle());
        g.drawLine(line.getStartX(), line.getStartY(), line.getEndX(), line.getEndY());
    }

    public void drawShape(Graphics2D g, DrawingElement element, Shape shape) {
        if (element.getStyle() != null) {
            this.setStyle(g, element, element.getStyle());
            g.fill(shape);
        }
        if (element.getBorder() != null) {
            this.setStyle(g, element, element.getBorder());
            g.draw(shape);
        }
    }

    public void drawRectangle(Graphics2D g, Rectangle rectangle) {
        Shape shape = new java.awt.Rectangle(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
        if (rectangle.getRotation() != 0.0) {
            AffineTransform at = new AffineTransform();
            at.rotate(rectangle.getRotation(), rectangle.getX(), rectangle.getY());
            shape = at.createTransformedShape(shape);
        }
        this.drawShape(g, rectangle, shape);
    }

    public void drawPolygon(Graphics2D g, Polygon polygon) {
        Shape shape = new java.awt.Polygon(polygon.getXCoords(), polygon.getYCoords(), polygon.getSides());
        if (polygon.getRotation() != 0.0) {
            AffineTransform at = new AffineTransform();
            at.rotate(polygon.getRotation(), polygon.getX(), polygon.getY());
            shape = at.createTransformedShape(shape);
        }
        this.drawShape(g, polygon, shape);
    }

    public void drawCircle(Graphics2D g, Circle circle) {
        int x = circle.getX();
        int y = circle.getY();
        int radius = circle.getRadius();
        if (circle.getStyle() != null) {
            this.setStyle(g, circle, circle.getStyle());
            g.fillOval(x, y, 2 * radius, 2 * radius);
        }
        if (circle.getBorder() != null) {
            this.setStyle(g, circle, circle.getBorder());
            g.drawOval(x, y, 2 * radius, 2 * radius);
        }
    }

    public void drawEllipse(Graphics2D g, Ellipse ellipse) {
        int x = ellipse.getX();
        int y = ellipse.getY();
        int radiusX = ellipse.getRadiusX();
        int radiusY = ellipse.getRadiusY();
        Shape shape = new Ellipse2D.Double(x, y, 2 * radiusX, 2 * radiusY);
        if (ellipse.getRotation() != 0.0) {
            AffineTransform at = new AffineTransform();
            at.rotate(ellipse.getRotation(), ellipse.getCenterX(), ellipse.getCenterY());
            shape = at.createTransformedShape(shape);
        }
        this.drawShape(g, ellipse, shape);
    }

    public void drawArc(Graphics2D g, Arc arc) {
        int x = arc.getX();
        int y = arc.getY();
        int radiusX = arc.getRadiusX();
        int radiusY = arc.getRadiusY();
        double startAngle = 180.0 * arc.getStartAngle() / Math.PI;
        double extent = 180.0 * arc.getExtent() / Math.PI;
        Shape shape = new Arc2D.Double(x, y, 2 * radiusX, 2 * radiusY, startAngle, extent, 2);
        if (arc.getRotation() != 0.0) {
            AffineTransform at = new AffineTransform();
            at.rotate(arc.getRotation(), arc.getCenterX(), arc.getCenterY());
            shape = at.createTransformedShape(shape);
        }
        this.drawShape(g, arc, shape);
    }

    public void drawBitmap(Graphics2D g, Bitmap bitmap) {
        Image image = (Image)this.images.get(bitmap.getUrl());
        if (image == null) {
            try {
                image = ImageIO.read(new URL(bitmap.getUrl()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (image != null) {
            if (bitmap.getRotation() != 0.0) {
                AffineTransform at = new AffineTransform();
                at.translate(bitmap.getX(), bitmap.getY());
                at.rotate(bitmap.getRotation());
                g.drawImage(image, at, this);
            } else {
                g.drawImage(image, bitmap.getX(), bitmap.getY(), bitmap.getX() + bitmap.getWidth(), bitmap.getY() + bitmap.getHeight(), null);
            }
        }
    }

    public void drawText(Graphics2D g, Text text) {
        this.setStyle(g, text, text.getStyle());
        g.drawString(text.getText(), text.getX(), text.getY());
    }

    public void setStyle(Graphics2D g, DrawingElement element, Style style) {
        if (style != null) {
            this.setColor(g, style);
            if (style instanceof FontStyle) {
                this.setFont(g, (FontStyle)style);
            } else if (style instanceof LinearGradient) {
                this.setLinearGradient(g, element, (LinearGradient)style);
            } else if (style instanceof RadialGradient) {
                this.setRadialGradient(g, element, (RadialGradient)style);
            }
        }
    }

    public void setColor(Graphics2D g, Style style) {
        g.setColor(style.getColor());
        g.setStroke(new BasicStroke(style.getWidth()));
    }

    public void setFont(Graphics2D g, FontStyle style) {
        if (style.getAngle() == 0.0) {
            g.setFont(style.getFont());
        } else {
            AffineTransform fontAT = new AffineTransform();
            fontAT.rotate(style.getAngle());
            g.setFont(style.getFont().deriveFont(fontAT));
        }
    }

    public void setLinearGradient(Graphics2D g, DrawingElement element, LinearGradient style) {
        Point2D.Float start = new Point2D.Float((float)element.getX() + (float)element.getWidth() * style.getStartX(), (float)element.getY() + (float)element.getHeight() * style.getStartY());
        Point2D.Float end = new Point2D.Float((float)element.getX() + (float)element.getWidth() * style.getEndX(), (float)element.getY() + (float)element.getHeight() * style.getEndY());
        float[] distribution = new float[style.getKeyframes().size()];
        Color[] colors = new Color[style.getKeyframes().size()];
        int i = 0;
        while (i < distribution.length) {
            distribution[i] = style.getKeyframe(i).getValue();
            colors[i] = style.getKeyframe(i).getColor();
            ++i;
        }
        LinearGradientPaint gradient = new LinearGradientPaint(start, end, distribution, colors);
        g.setPaint(gradient);
    }

    public void setRadialGradient(Graphics2D g, DrawingElement element, RadialGradient style) {
        Point2D.Float center = new Point2D.Float((float)element.getX() + (float)element.getWidth() * style.getCenterX(), (float)element.getY() + (float)element.getHeight() * style.getCenterY());
        float radius = (float)Math.max(element.getWidth(), element.getHeight()) * style.getRadius();
        float[] distribution = new float[style.getKeyframes().size()];
        Color[] colors = new Color[style.getKeyframes().size()];
        int i = 0;
        while (i < distribution.length) {
            distribution[i] = style.getKeyframe(i).getValue();
            colors[i] = style.getKeyframe(i).getColor();
            ++i;
        }
        RadialGradientPaint gradient = new RadialGradientPaint(center, radius, distribution, colors);
        g.setPaint(gradient);
    }

    public DrawingTooltipProvider getTooltipProvider() {
        return this.tooltipProvider;
    }

    public void setTooltipProvider(DrawingTooltipProvider tooltipProvider) {
        this.tooltipProvider = tooltipProvider;
    }

    public DrawingSelectionListener getSelectionListener() {
        return this.selectionListener;
    }

    public void setSelectionListener(DrawingSelectionListener selectionListener) {
        this.selectionListener = selectionListener;
    }

    public DrawingUpdateListener getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(DrawingUpdateListener actionListener) {
        this.actionListener = actionListener;
    }

    public DrawingUpdateListener getDraggingListener() {
        return this.draggingListener;
    }

    public void setDraggingListener(DrawingUpdateListener draggingListener) {
        this.draggingListener = draggingListener;
    }
}

