/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.graphics.swing;

import ikor.model.graphics.DrawingElement;
import ikor.model.graphics.swing.JDrawingComponent;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputListener;

public class JDrawingMouseListener
implements MouseInputListener {
    private JDrawingComponent control;
    private DrawingElement draggedElement;

    public JDrawingMouseListener(JDrawingComponent control) {
        this.control = control;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.control.getSelectionListener() != null) {
            this.updateSelection(e);
        } else if (this.control.getActionListener() != null) {
            int x = e.getX();
            int y = e.getY();
            String id = this.control.getDrawing().getElement(x, y);
            if (id != null) {
                this.control.getActionListener().update(id, x, y);
                this.control.repaint();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.control.getSelectionListener() != null) {
            this.updateSelection(e);
        }
        if (this.control.getDraggingListener() != null) {
            this.draggedElement = this.control.getDrawing().getDrawingElement(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.draggedElement = null;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.control.getDraggingListener() != null && this.draggedElement != null) {
            if (this.draggedElement.getId() != null) {
                this.control.getDraggingListener().update(this.draggedElement.getId(), e.getX(), e.getY());
                this.control.repaint();
            }
        } else if (this.control.getTooltipProvider() != null) {
            String tooltip;
            this.control.setToolTipText("");
            String id = this.control.getDrawing().getElement(e.getX(), e.getY());
            if (id != null && (tooltip = (String)this.control.getTooltipProvider().get(id)) != null) {
                this.control.setToolTipText(tooltip);
            }
        }
    }

    private void updateSelection(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        String id = this.control.getDrawing().getElement(x, y);
        if (e.isControlDown()) {
            this.control.getSelectionListener().addSelection(id);
        } else {
            this.control.getSelectionListener().setSelection(id);
        }
        this.control.repaint();
    }
}

