/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.ui;

import ikor.collection.Dictionary;
import ikor.collection.DynamicDictionary;
import ikor.model.Subject;
import ikor.model.ui.UI;
import ikor.model.ui.UIBuilder;
import ikor.model.ui.UIModel;

public abstract class Application
extends Subject<String>
implements Runnable {
    private String name;
    private UIModel startup;
    private UIBuilder builder;
    private Dictionary<String, Object> data = new DynamicDictionary<String, Object>();
    Dictionary<String, UI> userInterface = new DynamicDictionary<String, UI>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void set(String key, Object value) {
        this.data.set(key, value);
        this.notifyObservers(key);
    }

    public Object get(String key) {
        return this.data.get(key);
    }

    public UIModel getStartup() {
        return this.startup;
    }

    public void setStartup(UIModel startup) {
        this.startup = startup;
    }

    public UIBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(UIBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void run() {
        this.run(this.startup);
    }

    public void run(UIModel model) {
        if (this.builder != null) {
            UI ui = (UI)this.userInterface.get(model.getId());
            if (ui == null) {
                ui = this.builder.build(model);
                this.userInterface.set(model.getId(), ui);
            }
            ui.run();
            model.start();
        }
    }

    public void exit(UIModel model) {
        UI ui = (UI)this.userInterface.get(model.getId());
        ui.exit();
    }

    public void message(String msg) {
        this.builder.message(this.name, msg);
    }

    public boolean confirm(String question) {
        return this.builder.confirm(this.name, question);
    }

    public abstract String url(String var1);

    public void open(String url) {
        this.builder.open(url);
    }
}

