/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.ui;

import ikor.model.Observer;
import ikor.model.Subject;
import ikor.model.data.DataModel;
import ikor.model.ui.Component;
import ikor.model.ui.Label;

public class DataComponent<T>
extends Component<T>
implements Observer<T> {
    private T data;
    private DataModel<T> model;
    private Label label;
    boolean updating = false;

    public DataComponent(String id, DataModel<T> model) {
        super(id);
        this.model = model;
        this.label = new Label(id);
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        if (!this.updating) {
            try {
                this.updating = true;
                this.data = data;
                this.notifyObservers(data);
            }
            finally {
                this.updating = false;
            }
        }
    }

    public String getValue() {
        if (this.data != null) {
            return this.model.toString(this.data);
        }
        return "";
    }

    public boolean setValue(String value) {
        T obj = this.model.fromString(value);
        if (obj != null) {
            this.setData(obj);
        }
        return obj != null;
    }

    public DataModel<T> getModel() {
        return this.model;
    }

    public void setModel(DataModel<T> model) {
        this.model = model;
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public void setIcon(String icon) {
        this.label.setIcon(icon);
    }

    @Override
    public void update(Subject<T> subject, T object) {
        System.err.println(subject + "->" + object);
        this.setData(object);
    }
}

