/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.ui;

import ikor.collection.DynamicList;
import ikor.collection.List;
import ikor.model.Subject;
import ikor.model.data.Dataset;
import ikor.model.data.DatasetModel;
import ikor.model.ui.DatasetComponent;
import ikor.model.ui.DatasetSelection;
import ikor.model.ui.Editor;
import ikor.model.ui.Label;

public class DatasetEditor
extends Editor<Dataset>
implements DatasetComponent {
    private List<Label> headers = new DynamicList<Label>();
    private DatasetSelection selection;

    public DatasetEditor(String id, DatasetModel model) {
        super(id, model);
    }

    public DatasetEditor(String id, Subject<Dataset> subject, DatasetModel model) {
        super(id, subject, model);
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    @Override
    public void addHeader(Label header) {
        this.headers.add(header);
    }

    @Override
    public void addHeader(String text) {
        this.addHeader(new Label(text));
    }

    @Override
    public Label getHeader(int column) {
        if (column >= 0 && column < this.headers.size()) {
            return (Label)this.headers.get(column);
        }
        return null;
    }

    @Override
    public void setHeader(int column, Label header) {
        if (column >= 0 && column < this.headers.size()) {
            this.headers.set(column, header);
        }
    }

    @Override
    public void setHeader(int column, String text) {
        this.setHeader(column, new Label(text));
    }

    @Override
    public DatasetSelection getSelection() {
        return this.selection;
    }

    @Override
    public void setSelection(DatasetSelection selection) {
        this.selection = selection;
    }
}

