/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.ui;

import ikor.model.Subject;
import ikor.model.graphics.Drawing;
import ikor.model.graphics.DrawingSelectionListener;
import ikor.model.graphics.DrawingTooltipProvider;
import ikor.model.graphics.DrawingUpdateListener;
import ikor.model.ui.Component;

public class Figure<M>
extends Component<M> {
    private Drawing drawing;
    private M model;
    private DrawingTooltipProvider tooltipProvider;
    private DrawingUpdateListener draggingListener;
    private DrawingSelectionListener selectionListener;
    boolean updating = false;

    public Figure() {
    }

    public Figure(String id) {
        this.setId(id);
    }

    public M getModel() {
        return this.model;
    }

    public void setModel(M model) {
        this.model = model;
    }

    public Drawing getDrawing() {
        return this.drawing;
    }

    public void setDrawing(Drawing drawing) {
        this.drawing = drawing;
    }

    public void setSize(int width, int height) {
        this.drawing.setWidth(width);
        this.drawing.setHeight(height);
    }

    public void update() {
        this.drawing.update();
        if (!this.updating) {
            this.updating = true;
            this.notifyObservers();
            this.updating = false;
        }
    }

    @Override
    public void update(Subject subject, M object) {
        if (!this.updating) {
            this.updating = true;
            if (object != null) {
                this.setModel(object);
                this.notifyObservers(object);
            } else {
                this.setModel(null);
                this.notifyObservers();
            }
            this.updating = false;
        }
    }

    public DrawingTooltipProvider getTooltipProvider() {
        return this.tooltipProvider;
    }

    public void setTooltipProvider(DrawingTooltipProvider tooltipProvider) {
        this.tooltipProvider = tooltipProvider;
    }

    public DrawingUpdateListener getDraggingListener() {
        return this.draggingListener;
    }

    public void setDraggingListener(DrawingUpdateListener draggingListener) {
        this.draggingListener = draggingListener;
    }

    public DrawingSelectionListener getSelectionListener() {
        return this.selectionListener;
    }

    public void setSelectionListener(DrawingSelectionListener selectionListener) {
        this.selectionListener = selectionListener;
    }
}

