/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.ui;

import ikor.collection.DynamicList;
import ikor.collection.List;
import ikor.model.ui.Option;

public class Selector
extends Option {
    private boolean multipleSelection = false;
    private List<Option> options = new DynamicList<Option>();
    private List<Option> selected = new DynamicList<Option>();

    public List<Option> getOptions() {
        return this.options;
    }

    public void setItems(List<Option> options) {
        this.options = options;
    }

    public void clear() {
        this.selected.clear();
        this.options.clear();
        this.notifyObservers();
    }

    public void add(Option option) {
        this.options.add(option);
        this.notifyObservers();
    }

    public List<Option> getSelected() {
        return this.selected;
    }

    public Option getSelectedOption() {
        if (this.selected.size() > 0) {
            return (Option)this.selected.get(0);
        }
        return null;
    }

    public int getSelectedCount() {
        return this.selected.size();
    }

    public void clearSelected() {
        this.selected.clear();
    }

    public void setSelected(Option selectedOption) {
        this.selected.clear();
        this.selected.add(selectedOption);
    }

    public void addSelectedOption(Option selectedOption) {
        this.selected.add(selectedOption);
    }

    public void removeSelectedOption(Option selectedOption) {
        this.selected.remove(selectedOption);
    }

    public boolean isMultipleSelection() {
        return this.multipleSelection;
    }

    public void setMultipleSelection(boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
    }

    @Override
    public String toString() {
        String result = "[ ";
        for (Option selectedOption : this.selected) {
            result = String.valueOf(result) + "[" + selectedOption.toString() + "] ";
        }
        return String.valueOf(result) + "]";
    }
}

