/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.ui;

import ikor.collection.DynamicList;
import ikor.collection.List;
import ikor.model.ui.Application;
import ikor.model.ui.Component;
import ikor.model.ui.Label;

public class UIModel
extends Component<String> {
    private Application application;
    private List<Component> components;
    private Label title;
    private Alignment alignment;

    public UIModel(Application application) {
        this(application, application.getName());
    }

    public UIModel(Application application, String title) {
        this.application = application;
        this.components = new DynamicList<Component>();
        this.title = new Label(title);
        this.alignment = Alignment.CENTER;
    }

    public void start() {
    }

    public void exit() {
        this.application.exit(this);
    }

    public void message(String msg) {
        this.application.message(msg);
    }

    public boolean confirm(String question) {
        return this.application.confirm(question);
    }

    public Object get(String key) {
        return this.application.get(key);
    }

    public void set(String key, Object value) {
        this.application.set(key, value);
    }

    public Label getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = new Label(title);
    }

    public void setTitle(Label label) {
        this.title = label;
    }

    public void setIcon(String icon) {
        this.title.setIcon(icon);
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public void setComponents(List<Component> items) {
        this.components = items;
    }

    public void add(Component item) {
        this.components.add(item);
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public static enum Alignment {
        LEADING,
        CENTER,
        TRAILING,
        ADJUST;

    }
}

