/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.ui.swing;

import ikor.math.Decimal;
import ikor.model.data.ColorModel;
import ikor.model.data.DateModel;
import ikor.model.data.DecimalModel;
import ikor.model.data.RealModel;
import ikor.model.ui.DatasetSelection;
import ikor.model.ui.swing.SwingDatasetModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class SwingDatasetJTable
extends JTable {
    public static final int MINIMUM_WIDTH_PER_COLUMN = 50;
    public static final int PREFERRED_WIDTH_PER_COLUMN = 100;
    private List<RowSorter.SortKey> sortKeys;

    public SwingDatasetJTable(SwingDatasetModel model) {
        super(model);
        this.setFillsViewportHeight(true);
        this.setAutoCreateRowSorter(true);
        this.setAutoResizeMode(4);
        this.setupLayout();
        this.setupRenderers();
        this.setupEditors();
        this.getSelectionModel().addListSelectionListener(new DatasetSelectionListener(model));
        this.getRowSorter().addRowSorterListener(new DatasetSorterListener());
    }

    public void setupLayout() {
        int i = 0;
        while (i < this.getColumnCount()) {
            this.getColumnModel().getColumn(i).setMinWidth(50);
            this.getColumnModel().getColumn(i).setPreferredWidth(100);
            ++i;
        }
        this.getRowSorter().setSortKeys(this.sortKeys);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getMinimumSize().width < this.getParent().getWidth();
    }

    public void setupRenderers() {
        this.setDefaultRenderer(Float.class, new RealRenderer());
        this.setDefaultRenderer(Double.class, new RealRenderer());
        this.setDefaultRenderer(Decimal.class, new DecimalRenderer());
        this.setDefaultRenderer(Date.class, new DateRenderer());
        this.setDefaultRenderer(Color.class, new ColorRenderer());
    }

    public void setupEditors() {
        this.setDefaultEditor(Date.class, new DateEditor());
        this.setDefaultEditor(Color.class, new ColorEditor());
    }

    public class ColorEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        Color currentColor;
        JButton button = new JButton();
        JColorChooser colorChooser;
        JDialog dialog;
        private static final String EDIT = "edit";

        public ColorEditor() {
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
            this.colorChooser = new JColorChooser();
            this.dialog = JColorChooser.createDialog(this.button, "Color selection...", true, this.colorChooser, this, null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                this.button.setBackground(this.currentColor);
                this.colorChooser.setColor(this.currentColor);
                this.dialog.setVisible(true);
                this.fireEditingStopped();
            } else {
                this.currentColor = this.colorChooser.getColor();
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentColor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentColor = (Color)value;
            return this.button;
        }
    }

    public class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        ColorModel model = new ColorModel();

        public ColorRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
            Color color = (Color)object;
            this.setBackground(color);
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
            this.setToolTipText("RGB value: " + this.model.toString(color));
            return this;
        }
    }

    public class DatasetSelectionListener
    implements ListSelectionListener {
        SwingDatasetModel model;

        public DatasetSelectionListener(SwingDatasetModel model) {
            this.model = model;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel lsm;
            DatasetSelection selection = this.model.getSelection();
            if (selection != null && !(lsm = (ListSelectionModel)e.getSource()).isSelectionEmpty() && !lsm.getValueIsAdjusting()) {
                selection.clearSelection();
                int min = lsm.getMinSelectionIndex();
                int max = lsm.getMaxSelectionIndex();
                int i = min;
                while (i <= max) {
                    if (lsm.isSelectedIndex(i)) {
                        selection.addSelection(SwingDatasetJTable.this.convertRowIndexToModel(i));
                    }
                    ++i;
                }
            }
        }
    }

    public class DatasetSorterListener
    implements RowSorterListener {
        @Override
        public void sorterChanged(RowSorterEvent e) {
            Object sorter;
            if (RowSorterEvent.Type.SORT_ORDER_CHANGED == e.getType() && ((RowSorter)(sorter = e.getSource())).getSortKeys().size() > 0) {
                SwingDatasetJTable.this.sortKeys = ((RowSorter)sorter).getSortKeys();
            }
        }
    }

    public class DateEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private final DateModel model;
        private final Border red;
        private final Border black;

        public DateEditor() {
            super(new JTextField());
            this.model = new DateModel();
            this.red = new LineBorder(Color.red);
            this.black = new LineBorder(Color.black);
        }

        @Override
        public Object getCellEditorValue() {
            JTextField control = (JTextField)this.getComponent();
            Date date = this.model.fromString(control.getText());
            return date;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JTextField control = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (value != null && value instanceof Date) {
                control.setText(this.model.toString((Date)value));
            }
            control.setBorder(this.black);
            return control;
        }

        @Override
        public boolean stopCellEditing() {
            JTextField control = (JTextField)this.getComponent();
            Date date = null;
            date = this.model.fromString(control.getText());
            if (date == null) {
                control.setBorder(this.red);
                return false;
            }
            return super.stopCellEditing();
        }
    }

    public class DateRenderer
    extends DefaultTableCellRenderer {
        DateModel model = new DateModel();

        @Override
        public void setValue(Object value) {
            this.setHorizontalAlignment(4);
            if (value != null && value instanceof Date) {
                this.setText(this.model.toString((Date)value));
            }
        }
    }

    public class DecimalRenderer
    extends DefaultTableCellRenderer {
        DecimalModel model = new DecimalModel();

        @Override
        public void setValue(Object value) {
            this.setHorizontalAlignment(4);
            this.setText(value == null ? "" : this.model.toString((Number)value));
        }
    }

    public class RealRenderer
    extends DefaultTableCellRenderer {
        RealModel model = new RealModel();

        @Override
        public void setValue(Object value) {
            this.setHorizontalAlignment(4);
            this.setText(value == null ? "" : this.model.toString((Number)value));
        }
    }
}

