/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.ui.swing;

import ikor.model.data.Dataset;
import ikor.model.ui.DatasetComponent;
import ikor.model.ui.DatasetEditor;
import ikor.model.ui.DatasetSelection;
import ikor.model.ui.DatasetViewer;
import javax.swing.table.AbstractTableModel;

public class SwingDatasetModel
extends AbstractTableModel {
    private DatasetComponent component;
    private boolean editable;

    public SwingDatasetModel(DatasetViewer viewer, boolean editable) {
        this.component = viewer;
        this.editable = editable;
    }

    public SwingDatasetModel(DatasetEditor editor, boolean editable) {
        this.component = editor;
        this.editable = editable;
    }

    @Override
    public int getRowCount() {
        Dataset dataset = this.component.getData();
        if (dataset != null) {
            return dataset.getRowCount();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        Dataset dataset = this.component.getData();
        if (dataset != null) {
            return dataset.getColumnCount();
        }
        return 0;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.component.getHeader(columnIndex).getText();
    }

    public Class getColumnClass(int columnIndex) {
        Class<?> type = null;
        int i = 0;
        while (type == null && i < this.getRowCount()) {
            Object data = this.component.getData().get(i, columnIndex);
            if (data != null) {
                type = data.getClass();
            }
            ++i;
        }
        if (type != null) {
            return type;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.component.getData().get(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        this.component.getData().set(rowIndex, columnIndex, value);
        this.fireTableCellUpdated(rowIndex, columnIndex);
        this.component.notifyObservers(this.component.getData());
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.editable;
    }

    public DatasetSelection getSelection() {
        return this.component.getSelection();
    }
}

