/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.ui.swing;

import ikor.model.Observer;
import ikor.model.Subject;
import ikor.model.data.BooleanModel;
import ikor.model.data.ColorModel;
import ikor.model.data.DataModel;
import ikor.model.data.PasswordModel;
import ikor.model.data.TextModel;
import ikor.model.ui.Editor;
import ikor.model.ui.Label;
import ikor.model.ui.UIFactory;
import ikor.model.ui.swing.SwingUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class SwingEditorFactory
implements UIFactory<SwingUI, Editor> {
    @Override
    public void build(SwingUI ui, Editor editor) {
        DataModel model = editor.getModel();
        JComponent control = model instanceof BooleanModel ? this.createCheckBox(ui, editor) : this.createTextControl(ui, editor);
        ui.addComponent(control);
    }

    public JCheckBox createCheckBox(SwingUI ui, Editor editor) {
        Label label = editor.getLabel();
        JCheckBox control = new JCheckBox();
        control.setText(label.getText());
        if (label.getDescription() != null) {
            control.setToolTipText(label.getDescription());
        }
        if (label.getIcon() != null) {
            control.setIcon(ui.loadIcon(label.getIcon()));
        }
        CheckBoxMutator mutator = new CheckBoxMutator(editor, control);
        CheckBoxObserver observer = new CheckBoxObserver(mutator);
        CheckBoxListener listener = new CheckBoxListener(mutator);
        editor.addObserver(observer);
        control.addItemListener(listener);
        return control;
    }

    public JComponent createTextControl(SwingUI ui, Editor editor) {
        Label label = editor.getLabel();
        JLabel title = new JLabel();
        title.setText(label.getText());
        if (label.getDescription() != null) {
            title.setToolTipText(label.getDescription());
        }
        if (label.getIcon() != null) {
            title.setIcon(ui.loadIcon(label.getIcon()));
        }
        ui.addComponent(title);
        JTextComponent control = null;
        JScrollPane scrollPane = null;
        DataModel model = editor.getModel();
        if (model instanceof TextModel && ((TextModel)model).isMultiline()) {
            control = new JTextArea();
            scrollPane = new JScrollPane(control);
        } else {
            control = model instanceof PasswordModel ? new JPasswordField() : (model instanceof ColorModel ? new JColorTextField() : new JTextField());
        }
        control.setText(editor.getValue());
        control.setFont(title.getFont());
        control.setBackground(UIManager.getDefaults().getColor("TextField.background"));
        control.setEditable(true);
        TextFieldMutator mutator = new TextFieldMutator(editor, control);
        TextFieldObserver observer = new TextFieldObserver(mutator);
        TextFieldListener listener = new TextFieldListener(mutator);
        editor.addObserver(observer);
        if (control instanceof JTextField) {
            control.getDocument().addDocumentListener(listener);
            return control;
        }
        control.addKeyListener(listener);
        return scrollPane;
    }

    class CheckBoxListener
    implements ItemListener {
        CheckBoxMutator mutator;

        public CheckBoxListener(CheckBoxMutator mutator) {
            this.mutator = mutator;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.mutator.updateEditor();
        }
    }

    class CheckBoxMutator
    implements Runnable {
        Editor<Boolean> editor;
        JCheckBox control;
        boolean updating = false;

        public CheckBoxMutator(Editor editor, JCheckBox control) {
            this.editor = editor;
            this.control = control;
        }

        public void updateEditor() {
            if (!this.updating) {
                this.updating = true;
                this.editor.setValue(Boolean.valueOf(this.control.isSelected()).toString());
                this.updating = false;
            }
        }

        public void updateControl() {
            if (!this.updating) {
                this.updating = true;
                this.control.setSelected(Boolean.valueOf(this.editor.getValue()));
                this.updating = false;
            }
        }

        @Override
        public void run() {
            this.updateControl();
        }
    }

    public class CheckBoxObserver
    implements Observer {
        private CheckBoxMutator mutator;

        public CheckBoxObserver(CheckBoxMutator mutator) {
            this.mutator = mutator;
        }

        public void update(Subject o, Object arg) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.mutator.updateControl();
            } else {
                SwingUtilities.invokeLater(this.mutator);
            }
        }
    }

    public class JColorTextField
    extends JTextField {
        ColorModel model = new ColorModel();

        public Color getColor() {
            Color color = this.model.fromString(this.getText());
            if (color == null) {
                color = Color.black;
            }
            return color;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(this.getColor());
            g.fillRect(this.getWidth() - 24, 3, 20, this.getHeight() - 7);
            g.setColor(Color.black);
            g.drawRect(this.getWidth() - 24, 3, 20, this.getHeight() - 7);
        }
    }

    class TextFieldListener
    implements DocumentListener,
    KeyListener {
        TextFieldMutator mutator;

        public TextFieldListener(TextFieldMutator mutator) {
            this.mutator = mutator;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.mutator.updateEditor();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.mutator.updateEditor();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.mutator.updateEditor();
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.mutator.updateEditor();
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    class TextFieldMutator
    implements Runnable {
        Editor editor;
        JTextComponent control;
        boolean updating = false;

        public TextFieldMutator(Editor editor, JTextComponent control) {
            this.editor = editor;
            this.control = control;
        }

        public void updateEditor() {
            if (!this.updating) {
                this.updating = true;
                if (this.editor.setValue(this.control.getText())) {
                    this.control.setForeground(Color.black);
                } else {
                    this.control.setForeground(Color.red);
                }
                this.updating = false;
            }
        }

        public void updateControl() {
            if (!this.updating) {
                this.updating = true;
                this.control.setText(this.editor.getValue());
                this.updating = false;
            }
        }

        @Override
        public void run() {
            this.updateControl();
        }
    }

    public class TextFieldObserver
    implements Observer {
        private TextFieldMutator mutator;

        public TextFieldObserver(TextFieldMutator mutator) {
            this.mutator = mutator;
        }

        public void update(Subject o, Object arg) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.mutator.updateControl();
            } else {
                SwingUtilities.invokeLater(this.mutator);
            }
        }
    }
}

