/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.ui.swing;

import ikor.model.Observer;
import ikor.model.Subject;
import ikor.model.graphics.swing.JDrawingComponent;
import ikor.model.ui.Figure;
import ikor.model.ui.UIFactory;
import ikor.model.ui.swing.SwingUI;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.SwingUtilities;

public class SwingFigureFactory
implements UIFactory<SwingUI, Figure> {
    @Override
    public void build(SwingUI ui, Figure figure) {
        JDrawingComponent control = new JDrawingComponent(figure.getDrawing());
        if (figure.getTooltipProvider() != null) {
            control.setTooltipProvider(figure.getTooltipProvider());
        }
        if (figure.getDraggingListener() != null) {
            control.setDraggingListener(figure.getDraggingListener());
        }
        if (figure.getSelectionListener() != null) {
            control.setSelectionListener(figure.getSelectionListener());
        }
        control.addComponentListener(new JDrawingComponentListener(figure, control));
        figure.addObserver(new FigureObserver(figure, control));
        ui.addComponent(control);
        control.setVisible(figure.isVisible());
    }

    public class FigureObserver
    implements Observer {
        private Figure figure;
        private JDrawingComponent control;

        public FigureObserver(Figure figure, JDrawingComponent control) {
            this.figure = figure;
            this.control = control;
        }

        public void update(Subject o, Object arg) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FigureObserver.this.control.setDrawing(FigureObserver.this.figure.getDrawing());
                    FigureObserver.this.control.setVisible(FigureObserver.this.figure.isVisible());
                    FigureObserver.this.control.repaint();
                }
            });
        }
    }

    public class JDrawingComponentListener
    implements ComponentListener {
        private Figure figure;
        private JDrawingComponent control;

        public JDrawingComponentListener(Figure figure, JDrawingComponent control) {
            this.figure = figure;
            this.control = control;
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.figure.setSize(this.control.getWidth(), this.control.getHeight());
            this.figure.update();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JDrawingComponentListener.this.control.setVisible(JDrawingComponentListener.this.figure.isVisible());
                    JDrawingComponentListener.this.control.repaint();
                }
            });
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }
}

