/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.ui.swing;

import ikor.model.ui.Label;
import ikor.model.ui.UIFactory;
import ikor.model.ui.swing.SwingUI;
import java.awt.Desktop;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class SwingLabelFactory
implements UIFactory<SwingUI, Label> {
    @Override
    public void build(SwingUI ui, Label label) {
        JTextPane jlabel = new JTextPane();
        jlabel.addHyperlinkListener(new LabelHyperlinkListener());
        jlabel.setEditable(false);
        jlabel.setOpaque(false);
        jlabel.putClientProperty("JEditorPane.honorDisplayProperties", true);
        jlabel.setContentType("text/html");
        jlabel.setText(label.getText());
        if (label.getDescription() != null) {
            jlabel.setToolTipText(label.getDescription());
        }
        ui.addComponent(jlabel);
    }

    class LabelHyperlinkListener
    implements HyperlinkListener {
        LabelHyperlinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(event.getURL().toURI());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

