/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.ui.swing;

import ikor.collection.Dictionary;
import ikor.collection.DynamicDictionary;
import ikor.model.Observer;
import ikor.model.Subject;
import ikor.model.ui.Option;
import ikor.model.ui.Selector;
import ikor.model.ui.Separator;
import ikor.model.ui.UIFactory;
import ikor.model.ui.swing.SwingUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SwingSelectorFactory
implements UIFactory<SwingUI, Selector> {
    @Override
    public void build(SwingUI ui, Selector selector) {
        JList jlist = new JList();
        ListHandler handler = new ListHandler(selector);
        jlist.addListSelectionListener(new ListHandler(selector));
        this.updateList(ui, selector, jlist, handler);
        selector.addObserver(new ListObserver(ui, selector, jlist, handler));
        JScrollPane scroll = new JScrollPane(jlist);
        scroll.setMinimumSize(new Dimension(125, 25));
        ui.addComponent(scroll);
    }

    public void updateList(SwingUI ui, Selector selector, JList jlist, ListHandler handler) {
        JListModel model = new JListModel(ui, selector);
        JListRenderer renderer = new JListRenderer(model);
        if (selector.isMultipleSelection()) {
            jlist.setSelectionMode(2);
        } else {
            jlist.setSelectionMode(0);
        }
        jlist.setModel(model);
        jlist.setCellRenderer(renderer);
        handler.setSelector(selector);
    }

    class JListModel
    implements ListModel {
        private Selector selector;
        private Dictionary<String, ImageIcon> icons;

        public JListModel(SwingUI ui, Selector selector) {
            this.selector = selector;
            this.icons = new DynamicDictionary<String, ImageIcon>();
            for (Option option : selector.getOptions()) {
                ImageIcon icon = this.getIcon(option);
                if (icon != null || option.getLabel().getIcon() == null) continue;
                icon = ui.loadIcon(option.getLabel().getIcon());
                this.icons.set(option.getLabel().getIcon(), icon);
            }
        }

        public Object getElementAt(int index) {
            return this.selector.getOptions().get(index);
        }

        @Override
        public int getSize() {
            return this.selector.getOptions().size();
        }

        public ImageIcon getIcon(Option option) {
            return (ImageIcon)this.icons.get(option.getLabel().getIcon());
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }

    class JListRenderer
    extends DefaultListCellRenderer {
        JListModel model;

        public JListRenderer(JListModel model) {
            this.model = model;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            if (value instanceof Separator) {
                label = new JLabel();
                label.setBorder(BorderFactory.createLineBorder(Color.darkGray));
                label.setPreferredSize(new Dimension(1, 1));
            } else if (value instanceof Option) {
                Option option = (Option)value;
                label.setIcon(this.model.getIcon(option));
            }
            return label;
        }
    }

    class ListHandler
    implements ListSelectionListener {
        private Selector selector;

        public ListHandler(Selector selector) {
            this.selector = selector;
        }

        public void setSelector(Selector selector) {
            this.selector = selector;
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            block6: {
                JList list;
                block5: {
                    Option option;
                    list = (JList)event.getSource();
                    if (this.selector.isMultipleSelection()) break block5;
                    if (!(list.getSelectedValue() instanceof Option) || (option = (Option)list.getSelectedValue()) == this.selector.getSelectedOption()) break block6;
                    this.selector.setSelected(option);
                    if (option.getAction() == null) break block6;
                    option.getAction().run();
                    break block6;
                }
                if (!list.getValueIsAdjusting()) {
                    this.selector.clearSelected();
                    int i = 0;
                    while (i < list.getModel().getSize()) {
                        Option option = (Option)this.selector.getOptions().get(i);
                        if (list.isSelectedIndex(i)) {
                            this.selector.addSelectedOption(option);
                            if (option.getAction() != null) {
                                option.getAction().run();
                            }
                        } else {
                            this.selector.removeSelectedOption(option);
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public class ListObserver
    implements Observer {
        private SwingUI ui;
        private JList control;
        private Selector selector;
        private ListHandler handler;

        public ListObserver(SwingUI ui, Selector selector, JList control, ListHandler handler) {
            this.ui = ui;
            this.selector = selector;
            this.control = control;
            this.handler = handler;
        }

        public void update(Subject o, Object arg) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingSelectorFactory.this.updateList(ListObserver.this.ui, ListObserver.this.selector, ListObserver.this.control, ListObserver.this.handler);
                    ListObserver.this.control.updateUI();
                }
            });
        }
    }
}

