/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.ui.swing;

import ikor.collection.Dictionary;
import ikor.collection.DynamicDictionary;
import ikor.collection.Stack;
import ikor.model.ui.Component;
import ikor.model.ui.DatasetEditor;
import ikor.model.ui.DatasetViewer;
import ikor.model.ui.Editor;
import ikor.model.ui.Figure;
import ikor.model.ui.Image;
import ikor.model.ui.Label;
import ikor.model.ui.Menu;
import ikor.model.ui.Option;
import ikor.model.ui.Selector;
import ikor.model.ui.Separator;
import ikor.model.ui.UI;
import ikor.model.ui.UIFactory;
import ikor.model.ui.UIModel;
import ikor.model.ui.Viewer;
import ikor.model.ui.swing.SwingBackgroundFactory;
import ikor.model.ui.swing.SwingDatasetEditorFactory;
import ikor.model.ui.swing.SwingDatasetViewerFactory;
import ikor.model.ui.swing.SwingEditorFactory;
import ikor.model.ui.swing.SwingExitFactory;
import ikor.model.ui.swing.SwingFigureFactory;
import ikor.model.ui.swing.SwingIconFactory;
import ikor.model.ui.swing.SwingImageFactory;
import ikor.model.ui.swing.SwingLabelFactory;
import ikor.model.ui.swing.SwingMenuFactory;
import ikor.model.ui.swing.SwingOptionFactory;
import ikor.model.ui.swing.SwingSelectorFactory;
import ikor.model.ui.swing.SwingSeparatorFactory;
import ikor.model.ui.swing.SwingUIModelFactory;
import ikor.model.ui.swing.SwingViewerFactory;
import ikor.util.log.Log;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JSeparator;

public class SwingUI
extends JFrame
implements UI {
    UIModel context;
    Dictionary<Class, UIFactory> builders;
    Dictionary<String, UIFactory> options;
    GroupLayout layout;
    Stack<GroupLayout.Group> vertical;
    Stack<GroupLayout.Group> horizontal;
    Stack<UIModel> models;
    Stack<java.awt.Component> controls;
    static java.awt.Component dummy = new JSeparator();

    public SwingUI(UIModel context) {
        this.context = context;
        this.builders = new DynamicDictionary<Class, UIFactory>();
        this.builders.set(Menu.class, new SwingMenuFactory());
        this.builders.set(Image.class, new SwingImageFactory());
        this.builders.set(Figure.class, new SwingFigureFactory());
        this.builders.set(Label.class, new SwingLabelFactory());
        this.builders.set(Option.class, new SwingOptionFactory());
        this.builders.set(Selector.class, new SwingSelectorFactory());
        this.builders.set(Separator.class, new SwingSeparatorFactory());
        this.builders.set(Viewer.class, new SwingViewerFactory());
        this.builders.set(Editor.class, new SwingEditorFactory());
        this.builders.set(DatasetViewer.class, new SwingDatasetViewerFactory());
        this.builders.set(DatasetEditor.class, new SwingDatasetEditorFactory());
        this.builders.set(UIModel.class, new SwingUIModelFactory());
        this.options = new DynamicDictionary<String, UIFactory>();
        this.options.set("$icon", new SwingIconFactory());
        this.options.set("$exit", new SwingExitFactory());
        this.options.set("$background", new SwingBackgroundFactory());
        this.buildUI();
    }

    private void buildUI() {
        if (this.context.getTitle() != null) {
            Label label = this.context.getTitle();
            this.setTitle(label.getText());
            if (label.getIcon() != null) {
                this.setIconImage(this.loadIcon(label.getIcon()).getImage());
            }
        } else {
            this.setTitle(this.context.getId());
        }
        for (Component component : this.context.getComponents()) {
            if (!component.getId().startsWith("$")) continue;
            this.build(component);
        }
        this.initLayout(this.context);
        for (Component component : this.context.getComponents()) {
            if (component.getId().startsWith("$")) continue;
            this.build(component);
        }
        this.initDisplay();
    }

    public void build(Component component) {
        UIFactory factory = null;
        factory = component.getId().startsWith("$") ? (UIFactory)this.options.get(component.getId()) : this.getFactory(component.getClass());
        if (factory != null) {
            factory.build(this, component);
        } else {
            Log.warning("Unable to create UI widget for " + component);
        }
    }

    public UIFactory getFactory(Class type) {
        UIFactory factory = (UIFactory)this.builders.get(type);
        if (factory != null) {
            return factory;
        }
        if (type.getSuperclass() != null) {
            return this.getFactory(type.getSuperclass());
        }
        return null;
    }

    public GroupLayout initLayout(UIModel model) {
        this.layout = new GroupLayout(this.getContentPane());
        this.layout.setAutoCreateGaps(true);
        this.layout.setAutoCreateContainerGaps(true);
        this.getContentPane().setLayout(this.layout);
        this.vertical = new Stack();
        this.horizontal = new Stack();
        this.controls = new Stack();
        this.models = new Stack();
        this.vertical.push(this.layout.createSequentialGroup());
        this.horizontal.push(this.layout.createParallelGroup(this.getGroupAlignment(model)));
        this.models.push(model);
        this.controls.push(dummy);
        this.layout.setHorizontalGroup(this.horizontal.peek());
        this.layout.setVerticalGroup(this.vertical.peek());
        return this.layout;
    }

    @Override
    public GroupLayout getLayout() {
        return this.layout;
    }

    public void addComponent(java.awt.Component control) {
        this.horizontal.peek().addComponent(control);
        this.vertical.peek().addComponent(control);
        java.awt.Component last = this.controls.pop();
        if (last != dummy && this.models.peek().getAlignment() == UIModel.Alignment.ADJUST) {
            this.layout.linkSize(last, control);
        }
        this.controls.push(control);
    }

    private GroupLayout.Alignment getGroupAlignment(UIModel model) {
        GroupLayout.Alignment groupAlignment;
        switch (model.getAlignment()) {
            case LEADING: {
                groupAlignment = GroupLayout.Alignment.LEADING;
                break;
            }
            case CENTER: {
                groupAlignment = GroupLayout.Alignment.CENTER;
                break;
            }
            case TRAILING: {
                groupAlignment = GroupLayout.Alignment.TRAILING;
                break;
            }
            default: {
                groupAlignment = GroupLayout.Alignment.CENTER;
            }
        }
        return groupAlignment;
    }

    public void startGroup(UIModel model) {
        GroupLayout.Group newHorizontal;
        GroupLayout.Group newVertical;
        if (this.horizontal.size() % 2 == 0) {
            newVertical = this.layout.createSequentialGroup();
            newHorizontal = this.layout.createParallelGroup(this.getGroupAlignment(model));
        } else {
            newVertical = this.layout.createParallelGroup(this.getGroupAlignment(model));
            newHorizontal = this.layout.createSequentialGroup();
        }
        this.horizontal.peek().addGroup(newHorizontal);
        this.vertical.peek().addGroup(newVertical);
        this.horizontal.push(newHorizontal);
        this.vertical.push(newVertical);
        this.controls.push(dummy);
        this.models.push(model);
    }

    public void endGroup() {
        this.vertical.pop();
        this.horizontal.pop();
        this.controls.pop();
        this.models.pop();
    }

    public ImageIcon loadIcon(String location) {
        java.awt.Image image = this.loadImage(location);
        try {
            URL url = ClassLoader.getSystemClassLoader().getResource(location);
            image = new ImageIcon(url).getImage().getScaledInstance(32, 32, 4);
        }
        catch (Exception error) {
            Log.error("Loading icon " + location);
        }
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    public java.awt.Image loadImage(String location) {
        java.awt.Image image = null;
        try {
            URL url = ClassLoader.getSystemClassLoader().getResource(location);
            image = new ImageIcon(url).getImage();
        }
        catch (Exception error) {
            Log.error("Loading image " + location);
        }
        return image;
    }

    private void initDisplay() {
        int y;
        int x;
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        int width = gd.getDisplayMode().getWidth();
        int height = gd.getDisplayMode().getHeight();
        this.pack();
        Dimension size = this.getPreferredSize();
        switch (this.context.getAlignment()) {
            case LEADING: {
                x = 0;
                y = 0;
                break;
            }
            case TRAILING: {
                x = (int)((double)width - size.getWidth());
                y = (int)((double)height - size.getHeight());
                break;
            }
            case ADJUST: {
                x = 0;
                y = 0;
                this.setSize(width, height);
                break;
            }
            default: {
                x = (int)((double)width - size.getWidth()) / 2;
                y = (int)((double)height - size.getHeight()) / 2;
            }
        }
        this.setLocation(x, y);
    }

    @Override
    public void run() {
        this.setVisible(true);
    }

    @Override
    public void exit() {
        this.setVisible(false);
        if (this.context == this.context.getApplication().getStartup()) {
            System.exit(0);
        }
    }
}

