/*
 * Decompiled with CFR 0.152.
 */
package ikor.model.ui.swing;

import ikor.model.ui.File;
import ikor.model.ui.UI;
import ikor.model.ui.UIBuilder;
import ikor.model.ui.UIModel;
import ikor.model.ui.swing.SwingFileDialog;
import ikor.model.ui.swing.SwingUI;
import ikor.util.log.Log;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import javax.swing.JOptionPane;

public class SwingUIBuilder
extends UIBuilder {
    @Override
    public UI build(UIModel model) {
        if (model instanceof File) {
            return new SwingFileDialog((File)model);
        }
        return new SwingUI(model);
    }

    @Override
    public void open(String url) {
        try {
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (IOException e) {
            Log.error("Error while trying to open URL (" + url + ") - " + e.getMessage());
        }
    }

    @Override
    public void message(String title, String msg) {
        JOptionPane.showMessageDialog(null, msg, title, 1);
    }

    @Override
    public boolean confirm(String title, String query) {
        int reply = JOptionPane.showConfirmDialog(null, query, title, 0);
        return reply == 0;
    }
}

