/*
 * Decompiled with CFR 0.152.
 */
package ikor.parallel;

import ikor.parallel.Combiner;
import ikor.parallel.Kernel;
import ikor.parallel.Scheduler;
import ikor.parallel.Task;

public class Parallel {
    public static final int DEFAULT_TILE_WIDTH = 16;
    public static final int DEFAULT_DECOMPOSITION_DEPTH = 4;
    private static int tileWidth = 16;
    private static int decompositionDepth = 4;

    public static int getTileWidth() {
        return tileWidth;
    }

    public static void setTileWidth(int width) {
        tileWidth = width;
    }

    public static int getDecompositionDepth() {
        return decompositionDepth;
    }

    public static void setDecompositionDepth(int depth) {
        decompositionDepth = depth;
    }

    public static void forkjoin(Task a, Task b) {
        Scheduler scheduler = Scheduler.get();
        scheduler.schedule(a);
        scheduler.invoke(b);
        a.getResult();
    }

    public static void forkjoin(Task[] tasks) {
        Fork task = new Fork(tasks, 0, tasks.length - 1, decompositionDepth);
        task.call();
    }

    public static void map(Kernel kernel, int start, int end) {
        For task = new For(kernel, start, end, decompositionDepth);
        task.call();
    }

    public static Object reduce(Kernel kernel, Combiner combiner, int start, int end) {
        Reduce task = new Reduce(kernel, combiner, start, end, decompositionDepth);
        return task.call();
    }

    static class For
    extends Task {
        Kernel kernel;
        int start;
        int end;
        int depth;

        public For(Kernel kernel, int start, int end, int depth) {
            this.start = start;
            this.end = end;
            this.kernel = kernel;
            this.depth = depth;
        }

        @Override
        public Object call() {
            if (this.end - this.start >= tileWidth && this.depth > 0) {
                int middle = (this.start + this.end) / 2;
                For task1 = new For(this.kernel, this.start, middle, this.depth - 1);
                For task2 = new For(this.kernel, middle + 1, this.end, this.depth - 1);
                Parallel.forkjoin(task1, task2);
            } else {
                int i = this.start;
                while (i <= this.end) {
                    this.kernel.call(i);
                    ++i;
                }
            }
            return null;
        }
    }

    static class Fork
    extends Task {
        Task[] tasks;
        int start;
        int end;
        int depth;

        public Fork(Task[] tasks, int start, int end, int depth) {
            this.tasks = tasks;
            this.start = start;
            this.end = end;
            this.depth = depth;
        }

        @Override
        public Object call() {
            if (this.end - this.start >= tileWidth && this.depth > 0) {
                int middle = (this.start + this.end) / 2;
                Fork fork1 = new Fork(this.tasks, this.start, middle, this.depth - 1);
                Fork fork2 = new Fork(this.tasks, middle + 1, this.end, this.depth - 1);
                Parallel.forkjoin(fork1, fork2);
            } else {
                Scheduler scheduler = Scheduler.get();
                int i = this.start;
                while (i < this.end) {
                    scheduler.schedule(this.tasks[i]);
                    ++i;
                }
                scheduler.invoke(this.tasks[this.end]);
                i = this.start;
                while (i < this.end) {
                    this.tasks[i].getResult();
                    ++i;
                }
            }
            return null;
        }
    }

    static class Reduce<T>
    extends Task<T> {
        Kernel<T> kernel;
        Combiner<T> combiner;
        int start;
        int end;
        int depth;

        public Reduce(Kernel<T> kernel, Combiner<T> combiner, int start, int end, int depth) {
            this.kernel = kernel;
            this.combiner = combiner;
            this.start = start;
            this.end = end;
            this.depth = depth;
        }

        @Override
        public T call() {
            if (this.end - this.start >= tileWidth && this.depth > 0) {
                int middle = (this.start + this.end) / 2;
                Reduce<T> task1 = new Reduce<T>(this.kernel, this.combiner, this.start, middle, this.depth - 1);
                Reduce<T> task2 = new Reduce<T>(this.kernel, this.combiner, middle + 1, this.end, this.depth - 1);
                Parallel.forkjoin(task1, task2);
                return this.combiner.combine(task1.getResult(), task2.getResult());
            }
            T result = this.combiner.identity();
            int i = this.start;
            while (i <= this.end) {
                result = this.combiner.combine(result, this.kernel.call(i));
                ++i;
            }
            return result;
        }
    }
}

