/*
 * Decompiled with CFR 0.152.
 */
package ikor.parallel;

import ikor.parallel.Combiner;
import ikor.parallel.Getter;
import ikor.parallel.Parallel;
import ikor.parallel.Setter;
import ikor.parallel.Task;

public class Scan {
    public static void scan(Getter getter, Combiner combiner, Setter setter, int start, int end) {
        int depth = Parallel.getDecompositionDepth();
        int tileWidth = Parallel.getTileWidth();
        int n = end - start + 1;
        int tile = Math.max(tileWidth, n >> depth);
        if (n > 0) {
            int m = (n - 1) / tile;
            Object[] tmp = new Object[m + 1];
            Object initial = combiner.identity();
            Upsweep<Object> up = new Upsweep<Object>(getter, combiner, setter, 0, m + 1, tile, n - m * tile, tmp);
            Downsweep<Object> down = new Downsweep<Object>(getter, combiner, setter, 0, m + 1, tile, n - m * tile, tmp, initial);
            up.call();
            down.call();
        }
    }

    private static int split(int tiles) {
        int value = tiles;
        int power = 0;
        while (value > 2) {
            value >>= 1;
            ++power;
        }
        return 1 << power;
    }

    static class Downsweep<T>
    extends Task<T> {
        Combiner<T> combiner;
        Getter<T> getter;
        Setter<T> setter;
        T[] tmp;
        T initial;
        int first;
        int tiles;
        int tilesize;
        int last;

        public Downsweep(Getter<T> getter, Combiner<T> combiner, Setter<T> setter, int first, int tiles, int tilesize, int last, T[] tmp, T initial) {
            this.combiner = combiner;
            this.getter = getter;
            this.setter = setter;
            this.first = first;
            this.tiles = tiles;
            this.tilesize = tilesize;
            this.last = last;
            this.tmp = tmp;
            this.initial = initial;
        }

        private void scan(int start, int n, T initial) {
            T result = initial;
            int i = 0;
            while (i < n) {
                result = this.combiner.combine(result, this.getter.get(start + i));
                this.setter.set(start + i, result);
                ++i;
            }
        }

        @Override
        public T call() {
            if (this.tiles == 1) {
                this.scan(this.first * this.tilesize, this.last, this.initial);
            } else {
                int k = Scan.split(this.tiles);
                T intermediate = this.combiner.combine(this.initial, this.tmp[this.first + k - 1]);
                Downsweep<T> task1 = new Downsweep<T>(this.getter, this.combiner, this.setter, this.first, k, this.tilesize, this.tilesize, this.tmp, this.initial);
                Downsweep<T> task2 = new Downsweep<T>(this.getter, this.combiner, this.setter, this.first + k, this.tiles - k, this.tilesize, this.last, this.tmp, intermediate);
                Parallel.forkjoin(task1, task2);
            }
            return null;
        }
    }

    static class Upsweep<T>
    extends Task<T> {
        Combiner<T> combiner;
        Getter<T> getter;
        Setter<T> setter;
        T[] tmp;
        int offset;
        int first;
        int tiles;
        int tilesize;
        int last;

        public Upsweep(Getter<T> getter, Combiner<T> combiner, Setter<T> setter, int first, int tiles, int tilesize, int last, T[] tmp) {
            this.combiner = combiner;
            this.getter = getter;
            this.setter = setter;
            this.first = first;
            this.tiles = tiles;
            this.tilesize = tilesize;
            this.last = last;
            this.tmp = tmp;
        }

        private T reduce(int start, int n) {
            T result = this.combiner.identity();
            int i = 0;
            while (i < n) {
                result = this.combiner.combine(result, this.getter.get(start + i));
                ++i;
            }
            return result;
        }

        @Override
        public T call() {
            if (this.tiles == 1) {
                this.tmp[this.first] = this.reduce(this.first * this.tilesize, this.last);
            } else {
                int k = Scan.split(this.tiles);
                Upsweep<T> task1 = new Upsweep<T>(this.getter, this.combiner, this.setter, this.first, k, this.tilesize, this.tilesize, this.tmp);
                Upsweep<T> task2 = new Upsweep<T>(this.getter, this.combiner, this.setter, this.first + k, this.tiles - k, this.tilesize, this.last, this.tmp);
                Parallel.forkjoin(task1, task2);
                if (this.tiles >= 2 * k) {
                    this.tmp[this.first + this.tiles - 1] = this.combiner.combine(this.tmp[this.first + this.tiles - 1], this.tmp[this.first + k - 1]);
                }
            }
            return null;
        }
    }
}

