/*
 * Decompiled with CFR 0.152.
 */
package ikor.parallel;

import ikor.parallel.ITask;
import ikor.parallel.Scheduler;
import ikor.parallel.threading.MockFuture;
import java.io.Serializable;
import java.util.concurrent.Future;

public abstract class Task<T>
implements ITask<T>,
Serializable {
    private transient Future<T> future;

    @Override
    public abstract T call();

    @Override
    public T getResult() {
        try {
            return this.getFuture().get();
        }
        catch (Exception error) {
            error.printStackTrace();
            return null;
        }
    }

    @Override
    public void setResult(T result) {
        this.future = new MockFuture<T>(result);
    }

    @Override
    public void setFuture(Future<T> future) {
        this.future = future;
    }

    @Override
    public Future<T> getFuture() {
        if (this.future == null) {
            Scheduler.get().schedule(this);
        }
        return this.future;
    }
}

