/*
 * Decompiled with CFR 0.152.
 */
package ikor.parallel.scheduler;

import ikor.parallel.ITask;
import ikor.parallel.Scheduler;
import ikor.parallel.threading.MockFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class FutureScheduler
extends Scheduler {
    private ExecutorService executor;
    protected int nthreads;

    public FutureScheduler(int nthreads) {
        this.nthreads = nthreads;
        if (nthreads > 0) {
            this.executor = Executors.newFixedThreadPool(nthreads);
        }
    }

    @Override
    public void schedule(ITask task) {
        Future future = this.executor != null ? this.executor.submit(task) : new MockFuture(task.call());
        task.setFuture(future);
    }

    @Override
    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }
}

