/*
 * Decompiled with CFR 0.152.
 */
package ikor.parallel.threading;

import java.util.Vector;

public class ThreadPool
implements Runnable {
    public static final int DEFAULT_MINIMUM_SIZE = 0;
    public static final int DEFAULT_MAXIMUM_SIZE = 100;
    public static final long DEFAULT_RELEASE_DELAY = 60000L;
    private int minimumSize;
    private int maximumSize;
    private int currentSize;
    private int availableThreads;
    private long releaseDelay;
    private Vector taskList;

    public ThreadPool(int minSize, int maxSize, long delay) {
        this.minimumSize = minSize;
        this.maximumSize = maxSize;
        this.releaseDelay = delay;
        this.taskList = new Vector();
        this.availableThreads = 0;
    }

    public ThreadPool() {
        this(0, 100, 60000L);
    }

    public synchronized void setMinimumSize(int minSize) {
        this.minimumSize = minSize;
    }

    public synchronized int getMinimumSize() {
        return this.minimumSize;
    }

    public synchronized void setMaximumSize(int maxSize) {
        this.maximumSize = maxSize;
    }

    public synchronized int getMaximumSize() {
        return this.maximumSize;
    }

    public synchronized void setReleaseDelay(long delay) {
        this.releaseDelay = delay;
    }

    public synchronized long getReleaseDelay() {
        return this.releaseDelay;
    }

    public synchronized void addTask(Runnable runnable) {
        this.taskList.addElement(runnable);
        if (this.availableThreads > 0) {
            this.notifyAll();
        } else if (this.currentSize < this.maximumSize) {
            Thread t = new Thread(this);
            ++this.currentSize;
            t.start();
        }
    }

    protected synchronized Runnable getNextTask() {
        Runnable task = null;
        if (this.taskList.size() > 0) {
            task = (Runnable)this.taskList.elementAt(0);
            this.taskList.removeElementAt(0);
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Runnable task = null;
        boolean exit = false;
        while (!exit) {
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (this.currentSize > this.maximumSize) {
                    --this.currentSize;
                    task = null;
                    exit = true;
                } else {
                    task = this.getNextTask();
                    if (task == null) {
                        try {
                            ++this.availableThreads;
                            this.wait(this.releaseDelay);
                            --this.availableThreads;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        task = this.getNextTask();
                        if (task == null && this.currentSize > this.minimumSize) {
                            --this.currentSize;
                            exit = true;
                        }
                    }
                }
            }
            if (exit) continue;
            try {
                task.run();
            }
            catch (Exception e) {
                System.err.println("Thread pool: Uncaught exception");
                e.printStackTrace(System.err);
            }
        }
    }
}

