/*
 * Decompiled with CFR 0.152.
 */
package ikor.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class Executor {
    private static boolean verbose = true;

    public static void setVerbose(boolean verboseFlag) {
        verbose = verboseFlag;
    }

    public static boolean getVerbose() {
        return verbose;
    }

    public static boolean exec(String command) {
        return Executor.exec(command, false, false);
    }

    public static boolean execWait(String command) {
        return Executor.exec(command, false, true);
    }

    public static boolean execPrint(String command) {
        return Executor.exec(command, true, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean exec(String command, boolean printResults, boolean wait) {
        if (verbose) {
            Executor.printSeparator();
            System.out.println("Executing '" + command + "'.");
        }
        try {
            Process p = Runtime.getRuntime().exec(command);
            if (printResults) {
                BufferedInputStream buffer = new BufferedInputStream(p.getInputStream());
                BufferedReader commandResult = new BufferedReader(new InputStreamReader(buffer));
                String s = null;
                try {
                    while (true) {
                        if ((s = commandResult.readLine()) == null) {
                            commandResult.close();
                            if (p.exitValue() == 0) return true;
                            if (!verbose) return false;
                            Executor.printError(String.valueOf(command) + " -- p.exitValue() != 0");
                            return false;
                        }
                        System.out.println("Output: " + s);
                    }
                }
                catch (Exception exception) {
                    return true;
                }
            }
            if (!wait) return true;
            try {
                System.out.println(" ");
                int returnVal = p.waitFor();
                if (returnVal == 0) return true;
                if (!verbose) return false;
                Executor.printError(command);
                return false;
            }
            catch (Exception e) {
                if (!verbose) return false;
                Executor.printError(command, e);
                return false;
            }
        }
        catch (Exception e) {
            if (!verbose) return false;
            Executor.printError(command, e);
            return false;
        }
    }

    private static void printError(String command, Exception e) {
        System.out.println("Error doing exec(" + command + "): " + e.getMessage());
        System.out.println("Did you specify the full pathname?");
    }

    private static void printError(String command) {
        System.out.println("Error executing '" + command + "'.");
    }

    private static void printSeparator() {
        System.out.println("==============================================");
    }
}

