/*
 * Decompiled with CFR 0.152.
 */
package ikor.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.PropertyResourceBundle;
import javax.swing.ImageIcon;

public class Loader {
    public static Image loadImage(Class baseClass, String file) throws IOException {
        byte[] imageData = Loader.loadResource(baseClass, file);
        Image img = Toolkit.getDefaultToolkit().createImage(imageData);
        return img;
    }

    public static ImageIcon loadImageIcon(Class baseClass, String file) throws IOException {
        byte[] iconData = Loader.loadResource(baseClass, file);
        return new ImageIcon(iconData);
    }

    public static byte[] loadResource(Class baseClass, String file) throws IOException {
        byte[] buffer = null;
        try {
            InputStream resource = baseClass.getResourceAsStream(file);
            if (resource != null) {
                int n;
                BufferedInputStream in = new BufferedInputStream(resource);
                ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                buffer = new byte[1024];
                while ((n = in.read(buffer)) > 0) {
                    out.write(buffer, 0, n);
                }
                in.close();
                out.flush();
                buffer = out.toByteArray();
                if (buffer.length == 0) {
                    System.err.println("Warning: " + file + " is zero-length");
                }
            } else {
                System.err.println(String.valueOf(baseClass.getName()) + "/" + file + " not found.");
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
            throw ioe;
        }
        return buffer;
    }

    public static PropertyResourceBundle getResourceBundle(Class baseClass, String file) throws IOException {
        InputStream resource;
        block3: {
            try {
                resource = baseClass.getResourceAsStream(file);
                if (resource != null) break block3;
                System.err.println(String.valueOf(baseClass.getName()) + "/" + file + " not found.");
                return null;
            }
            catch (IOException ioe) {
                System.err.println(ioe.toString());
                throw ioe;
            }
        }
        BufferedInputStream in = new BufferedInputStream(resource);
        PropertyResourceBundle rb = new PropertyResourceBundle(in);
        in.close();
        return rb;
    }
}

