/*
 * Decompiled with CFR 0.152.
 */
package ikor.util.indexer;

import ikor.collection.Dictionary;
import ikor.collection.DynamicDictionary;
import ikor.util.indexer.Indexer;

public class DictionaryIndexer<T>
extends Indexer<T> {
    private Dictionary<T, Integer> dictionary = new DynamicDictionary<T, Integer>();
    private int max = -1;

    public void add(T value) {
        Integer entry;
        if (value != null && (entry = (Integer)this.dictionary.get(value)) == null) {
            this.dictionary.set(value, this.max + 1);
            ++this.max;
        }
    }

    public void add(T value, int index) {
        if (value != null) {
            this.dictionary.set(value, index);
            if (index > this.max) {
                this.max = index;
            }
        }
    }

    @Override
    public int index(T value) {
        Integer index = null;
        if (value != null) {
            index = (Integer)this.dictionary.get(value);
        }
        if (index != null) {
            return index;
        }
        return 0;
    }

    @Override
    public int min() {
        return 0;
    }

    @Override
    public int max() {
        return this.max;
    }
}

