/*
 * Decompiled with CFR 0.152.
 */
package ikor.util.indexer;

import ikor.util.indexer.Indexer;

public class ValueIndexer
extends Indexer<Double> {
    private double min;
    private double max;
    private int n;

    public ValueIndexer(double min, double max, int n) {
        this.min = min;
        this.max = max;
        this.n = n;
    }

    @Override
    public int index(Double value) {
        if (value != null && this.max > this.min) {
            return (int)((double)this.n * (value - this.min) / (this.max - this.min));
        }
        return 0;
    }

    public double minValue() {
        return this.min;
    }

    public double maxValue() {
        return this.max;
    }

    @Override
    public int min() {
        return 0;
    }

    @Override
    public int max() {
        return this.n;
    }
}

