/*
 * Decompiled with CFR 0.152.
 */
package ikor.util.jdbc;

import ikor.util.jdbc.JDBCConnectionPool;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class JDBCConnectionDriver
implements Driver {
    private String URL_PREFIX = "pool:";
    private Driver driver;
    private JDBCConnectionPool pool;

    public JDBCConnectionDriver(String driver, String url, String user, String password) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        Driver available = null;
        this.URL_PREFIX = "pool:" + url + ":" + user + ":" + password;
        try {
            available = DriverManager.getDriver(this.URL_PREFIX);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (available == null) {
            DriverManager.registerDriver(this);
            this.driver = (Driver)Class.forName(driver).newInstance();
            this.pool = new JDBCConnectionPool(url, user, password);
        }
    }

    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        if (!url.startsWith(this.URL_PREFIX)) {
            return null;
        }
        return this.pool.getConnection();
    }

    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith(this.URL_PREFIX);
    }

    @Override
    public int getMajorVersion() {
        return this.driver.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.driver.getMinorVersion();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String str, Properties props) throws SQLException {
        return this.driver.getPropertyInfo(str, props);
    }

    @Override
    public boolean jdbcCompliant() {
        return this.driver.jdbcCompliant();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

