/*
 * Decompiled with CFR 0.152.
 */
package ikor.util.jdbc;

import ikor.util.jdbc.JDBCConnection;
import ikor.util.jdbc.JDBCConnectionReaper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class JDBCConnectionPool {
    private Vector connections;
    private String url;
    private String user;
    private String password;
    private int activeConnections;
    private JDBCConnectionReaper reaper;
    private final int reaperStartThreshold = 0;
    private final int reaperStopThreshold = 0;
    private final long timeout = 3600000L;
    private final int poolsize = 10;

    public JDBCConnectionPool(String url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.connections = new Vector(10);
        this.activeConnections = 0;
        this.reaper = null;
    }

    public synchronized void startReaper() {
        if (this.reaper == null) {
            this.reaper = new JDBCConnectionReaper(this);
            this.reaper.setPriority(1);
            this.reaper.setDaemon(true);
            this.reaper.start();
        }
    }

    public synchronized void stopReaper() {
        if (this.reaper != null) {
            this.reaper.stopRequest();
            this.reaper = null;
        }
    }

    public synchronized void reapConnections() {
        long stale = System.currentTimeMillis() - 3600000L;
        Enumeration connlist = this.connections.elements();
        while (connlist != null && connlist.hasMoreElements()) {
            JDBCConnection conn = (JDBCConnection)connlist.nextElement();
            if (!conn.inUse() || stale <= conn.getLastUse() || conn.validate()) continue;
            this.removeConnection(conn);
            --this.activeConnections;
        }
        if (this.activeConnections < 0) {
            this.stopReaper();
        }
    }

    public synchronized void closeConnections() {
        Enumeration connlist = this.connections.elements();
        while (connlist != null && connlist.hasMoreElements()) {
            JDBCConnection conn = (JDBCConnection)connlist.nextElement();
            this.removeConnection(conn);
        }
        this.activeConnections = 0;
        this.stopReaper();
    }

    private synchronized void removeConnection(JDBCConnection conn) {
        try {
            conn.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connections.removeElement(conn);
    }

    public synchronized Connection getConnection() throws SQLException {
        JDBCConnection wrapper = null;
        int i = 0;
        while (i < this.connections.size() && wrapper == null) {
            JDBCConnection aux = (JDBCConnection)this.connections.elementAt(i);
            if (aux.lease()) {
                wrapper = aux;
            }
            ++i;
        }
        if (wrapper == null) {
            Connection real = DriverManager.getConnection(this.url, this.user, this.password);
            wrapper = new JDBCConnection(real, this);
            wrapper.lease();
            this.connections.addElement(wrapper);
        }
        ++this.activeConnections;
        if (this.activeConnections > 0) {
            this.startReaper();
        }
        return wrapper;
    }

    public synchronized void returnConnection(JDBCConnection conn) {
        --this.activeConnections;
        if (this.activeConnections < 0) {
            this.stopReaper();
        }
        if (this.connections.size() - this.activeConnections < 10) {
            conn.expireLease();
        } else {
            this.removeConnection(conn);
        }
    }
}

