/*
 * Decompiled with CFR 0.152.
 */
package ikor.util.xml;

import ikor.util.xml.XmlWriter;

public class MemoryXmlWriter
implements XmlWriter {
    private StringBuffer buffer = new StringBuffer();
    private String prefix = "";
    private String LEVEL_PREFIX = "  ";

    public String toString() {
        return this.buffer.toString();
    }

    @Override
    public void close() {
    }

    @Override
    public void write(Object object) {
        this.buffer.append(String.valueOf(this.prefix) + object + "\n");
    }

    @Override
    public void write(String id, Object attribute) {
        this.buffer.append(String.valueOf(this.prefix) + "- " + id + ": " + attribute + "\n");
    }

    @Override
    public void start(String id) {
        this.buffer.append(String.valueOf(this.prefix) + id + "\n");
        this.prefix = String.valueOf(this.prefix) + this.LEVEL_PREFIX;
    }

    @Override
    public void end(String id) {
        if (this.prefix.length() > this.LEVEL_PREFIX.length()) {
            this.prefix = this.prefix.substring(0, this.prefix.length() - this.LEVEL_PREFIX.length());
        }
    }

    @Override
    public void comment(String comment) {
        this.buffer.append(String.valueOf(this.prefix) + " /* " + comment + " */");
    }
}

