/*
 * Decompiled with CFR 0.152.
 */
package ikor.util.xml;

import ikor.util.xml.XmlWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class StaxXmlWriter
implements XmlWriter {
    private OutputStream out;
    private XMLStreamWriter writer;

    public StaxXmlWriter(OutputStream out) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        this.out = out;
        this.writer = factory.createXMLStreamWriter(out, "ISO-8859-1");
        this.writer.writeStartDocument("ISO-8859-1", "1.0");
    }

    public StaxXmlWriter(String filename) throws IOException, XMLStreamException {
        this(new FileOutputStream(filename));
    }

    public String normalize(String original) {
        if (original != null) {
            return original.toLowerCase();
        }
        return null;
    }

    @Override
    public void close() {
        try {
            this.writer.writeEndDocument();
            this.writer.flush();
            this.writer.close();
            this.out.close();
        }
        catch (Exception error) {
            System.err.println("StAX Error - " + error);
            error.printStackTrace();
        }
    }

    @Override
    public void end(String id) {
        try {
            this.writer.writeEndElement();
        }
        catch (Exception error) {
            System.err.println("StAX Error - " + error);
            error.printStackTrace();
        }
    }

    @Override
    public void start(String id) {
        try {
            this.writer.writeStartElement(this.normalize(id));
        }
        catch (Exception error) {
            System.err.println("StAX Error - " + error);
            error.printStackTrace();
        }
    }

    @Override
    public void write(Object object) {
        try {
            this.writer.writeCharacters(object.toString());
        }
        catch (Exception error) {
            System.err.println("StAX Error - " + error);
            error.printStackTrace();
        }
    }

    @Override
    public void write(String id, Object object) {
        try {
            this.writer.writeAttribute(this.normalize(id), object.toString());
        }
        catch (Exception error) {
            System.err.println("StAX Error - " + error);
            error.printStackTrace();
        }
    }

    @Override
    public void comment(String comment) {
        try {
            this.writer.writeComment(comment);
        }
        catch (Exception error) {
            System.err.println("StAX Error - " + error);
            error.printStackTrace();
        }
    }
}

