/*
 * Decompiled with CFR 0.152.
 */
package ikor.util.xml.rss;

import ikor.util.xml.rss.Feed;
import ikor.util.xml.rss.FeedMessage;
import ikor.util.xml.rss.FeedReader;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AtomFeedReader
extends FeedReader {
    public AtomFeedReader(String url) {
        super(url);
    }

    @Override
    public Feed read() {
        Feed feed = null;
        try {
            InputStream input = this.getInputStream();
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(input);
            XPath xpath = XPathFactory.newInstance().newXPath();
            String date = xpath.evaluate("/feed/updated", xmlDocument);
            String title = xpath.evaluate("/feed/title", xmlDocument);
            String content = xpath.evaluate("/feed/content", xmlDocument);
            String author = xpath.evaluate("/feed/author", xmlDocument);
            String link = xpath.evaluate("/feed/link[@rel='self']/@href", xmlDocument);
            String id = xpath.evaluate("/feed/id", xmlDocument);
            String language = xpath.evaluate("/feed/language", xmlDocument);
            String copyright = xpath.evaluate("/feed/rights", xmlDocument);
            feed = new Feed(title, link, content, language, copyright, date);
            NodeList entries = (NodeList)xpath.evaluate("/feed/entry", xmlDocument, XPathConstants.NODESET);
            int i = 0;
            while (i < entries.getLength()) {
                Element entry = (Element)entries.item(i);
                title = xpath.evaluate("title", entry);
                content = ((Node)xpath.evaluate("content", entry, XPathConstants.NODE)).getTextContent();
                author = String.valueOf(xpath.evaluate("author/email", entry)) + " (" + xpath.evaluate("author/name", entry) + ")";
                date = xpath.evaluate("updated", entry);
                link = xpath.evaluate("link[@rel='self']/@href", entry);
                id = xpath.evaluate("id", entry);
                FeedMessage message = new FeedMessage(title, content, author, date, link, id);
                feed.add(message);
                ++i;
            }
            input.close();
        }
        catch (Exception e) {
            feed = null;
        }
        return feed;
    }

    public static String nodeToString(Node node) throws TransformerException {
        StringWriter sw = new StringWriter();
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("omit-xml-declaration", "yes");
        t.setOutputProperty("indent", "yes");
        t.transform(new DOMSource(node), new StreamResult(sw));
        return sw.toString();
    }

    public static void main(String[] args) {
        AtomFeedReader reader = new AtomFeedReader(args[0]);
        Feed feed = reader.read();
        System.out.println("URL " + args[0]);
        System.out.println(feed);
        for (FeedMessage message : feed.getMessages()) {
            System.out.println(message);
        }
    }
}

