/*
 * Decompiled with CFR 0.152.
 */
package ikor.util.xml.rss;

import ikor.util.xml.rss.Feed;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public abstract class FeedReader {
    private URL url;
    private static final String AGENT = "Lynx/2.8.8dev.3 libwww-FM/2.14 SSL-MM/1.4.1";

    public FeedReader(String feedURL) {
        try {
            try {
                this.url = new URL(this.expandURL(feedURL));
            }
            catch (IOException e) {
                this.url = new URL(feedURL);
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private String expandURL(String shortenedURL) throws IOException {
        URL url = new URL(shortenedURL);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("User-Agent", AGENT);
        connection.setInstanceFollowRedirects(false);
        String expandedURL = connection.getHeaderField("Location");
        return expandedURL;
    }

    public abstract Feed read();

    protected XMLEventReader getStAXreader() throws FactoryConfigurationError, XMLStreamException, IOException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        return inputFactory.createXMLEventReader(this.getInputStream());
    }

    protected XMLStreamReader getStreamReader() throws XMLStreamException, IOException {
        InputStream input = this.getInputStream();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        return factory.createXMLStreamReader(input);
    }

    protected InputStream getInputStream() throws IOException {
        return this.url.openStream();
    }

    protected String getCharacterData(XMLEvent event, XMLEventReader eventReader) throws XMLStreamException {
        String result = "";
        event = eventReader.nextEvent();
        if (event instanceof Characters) {
            result = event.asCharacters().getData();
        }
        return result;
    }

    protected String getElementText(XMLEvent event, XMLEventReader eventReader) throws XMLStreamException {
        return eventReader.getElementText();
    }

    protected String getAttribute(XMLEvent event, XMLEventReader eventReader, String id) {
        String result = "";
        Iterator<Attribute> iterator = ((StartElement)event).getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            if (!attribute.getName().getLocalPart().equals(id)) continue;
            result = attribute.getValue();
        }
        return result;
    }
}

