/*
 * Decompiled with CFR 0.152.
 */
package ikor.util.xml.rss;

import ikor.util.xml.rss.Feed;
import ikor.util.xml.rss.FeedMessage;
import ikor.util.xml.rss.FeedReader;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.XMLEvent;

public class RSSFeedReader
extends FeedReader {
    static final String TITLE = "title";
    static final String DESCRIPTION = "description";
    static final String CHANNEL = "channel";
    static final String LANGUAGE = "language";
    static final String COPYRIGHT = "copyright";
    static final String LINK = "link";
    static final String AUTHOR = "author";
    static final String ITEM = "item";
    static final String PUB_DATE = "pubDate";
    static final String GUID = "guid";

    public RSSFeedReader(String url) {
        super(url);
    }

    @Override
    public Feed read() {
        Feed feed = null;
        try {
            boolean isFeedHeader = true;
            String description = "";
            String title = "";
            String link = "";
            String language = "";
            String copyright = "";
            String author = "";
            String pubdate = "";
            String guid = "";
            XMLEventReader eventReader = this.getStAXreader();
            while (eventReader.hasNext()) {
                XMLEvent event;
                block35: {
                    String localPart;
                    event = eventReader.nextEvent();
                    if (!event.isStartElement()) break block35;
                    switch (localPart = event.asStartElement().getName().getLocalPart()) {
                        case "item": {
                            if (isFeedHeader) {
                                isFeedHeader = false;
                                feed = new Feed(title, link, description, language, copyright, pubdate);
                            }
                            event = eventReader.nextEvent();
                            break;
                        }
                        case "title": {
                            title = this.getCharacterData(event, eventReader);
                            break;
                        }
                        case "description": {
                            description = this.getCharacterData(event, eventReader);
                            break;
                        }
                        case "link": {
                            link = this.getCharacterData(event, eventReader);
                            break;
                        }
                        case "guid": {
                            guid = this.getCharacterData(event, eventReader);
                            break;
                        }
                        case "language": {
                            language = this.getCharacterData(event, eventReader);
                            break;
                        }
                        case "author": {
                            author = this.getCharacterData(event, eventReader);
                            break;
                        }
                        case "pubDate": {
                            pubdate = this.getCharacterData(event, eventReader);
                            break;
                        }
                        case "copyright": {
                            copyright = this.getCharacterData(event, eventReader);
                        }
                    }
                    continue;
                }
                if (!event.isEndElement() || event.asEndElement().getName().getLocalPart() != ITEM) continue;
                FeedMessage message = new FeedMessage(title, description, author, pubdate, link, guid);
                feed.add(message);
                event = eventReader.nextEvent();
            }
            eventReader.close();
        }
        catch (Exception e) {
            feed = null;
        }
        return feed;
    }

    public static void main(String[] args) {
        RSSFeedReader reader = new RSSFeedReader(args[0]);
        Feed feed = reader.read();
        System.out.println(feed);
        for (FeedMessage message : feed.getMessages()) {
            System.out.println(message);
        }
    }
}

