/*
 * Decompiled with CFR 0.152.
 */
package noesis;

import ikor.collection.CollectionFactory;
import ikor.collection.Dictionary;
import ikor.collection.List;
import noesis.BasicNetwork;
import noesis.Network;

public class ArrayNetwork<V, E>
extends Network<V, E> {
    private BasicNetwork net = new BasicNetwork();
    private List<V> nodes = CollectionFactory.createList();
    private List<E>[] content;
    private Dictionary<V, Integer> hash = CollectionFactory.createDictionary();

    @Override
    public final int nodes() {
        return this.net.nodes();
    }

    @Override
    public final void setSize(int size) {
        this.net.setSize(size);
    }

    @Override
    public final int links() {
        return this.net.links();
    }

    @Override
    public int add(V node) {
        int pos = this.nodes.size();
        this.nodes.add(node);
        this.hash.set((Integer)node, pos);
        if (this.nodes.size() >= this.size()) {
            this.setSize(this.nodes.size());
        }
        return pos;
    }

    @Override
    public boolean remove(int nodeIndex) {
        throw new UnsupportedOperationException("Node removal is not allowed.");
    }

    @Override
    public final boolean add(int source, int destination) {
        return this.net.add(source, destination);
    }

    @Override
    public final boolean add(int sourceIndex, int destinationIndex, E value) {
        boolean ok = this.add(sourceIndex, destinationIndex);
        if (ok) {
            if (this.content == null) {
                this.content = new List[this.size()];
            }
            if (this.content[sourceIndex] == null) {
                this.content[sourceIndex] = CollectionFactory.createList();
            }
            this.content[sourceIndex].add(value);
        }
        return ok;
    }

    @Override
    public boolean remove(int sourceIndex, int destinationIndex) {
        throw new UnsupportedOperationException("Link removal is not allowed.");
    }

    @Override
    public boolean remove(int sourceIndex, int destinationIndex, E content) {
        throw new UnsupportedOperationException("Link removal is not allowed.");
    }

    @Override
    public final V get(int index) {
        if (this.nodes != null) {
            return (V)this.nodes.get(index);
        }
        return null;
    }

    @Override
    public final void set(int index, V value) {
        this.nodes.set(index, value);
        this.hash.set((Integer)value, index);
    }

    @Override
    public final E get(int source, int destination) {
        if (this.content != null && this.content[source] != null) {
            int index = this.net.getLinkIndex(source, destination);
            if (index != -1) {
                return (E)this.content[source].get(index);
            }
            return null;
        }
        return null;
    }

    @Override
    public final boolean contains(int source, int destination) {
        if (this.content != null && this.content[source] != null) {
            int index = this.net.getLinkIndex(source, destination);
            return index != -1;
        }
        return false;
    }

    @Override
    public final boolean contains(V node) {
        return this.hash.contains(node);
    }

    @Override
    public final int index(V node) {
        Integer entry = (Integer)this.hash.get(node);
        if (entry != null) {
            return entry;
        }
        return -1;
    }

    @Override
    public final int inDegree(int node) {
        return this.net.inDegree(node);
    }

    @Override
    public final int outDegree(int node) {
        return this.net.outDegree(node);
    }

    @Override
    public int outLink(int node, int index) {
        return this.net.outLink(node, index);
    }

    @Override
    public int inLink(int node, int index) {
        return this.net.inLink(node, index);
    }

    @Override
    public String toString() {
        return "[" + super.toString() + "] (" + this.size() + " nodes, " + this.links() + " links)";
    }
}

