/*
 * Decompiled with CFR 0.152.
 */
package noesis;

import ikor.model.data.RealModel;
import noesis.Attribute;
import noesis.AttributeSet;
import noesis.BasicNetwork;
import noesis.LinkAttribute;
import noesis.Network;
import noesis.network.LinkDictionaryIndex;
import noesis.network.LinkIndexer;

public class AttributeNetwork
extends BasicNetwork
implements LinkIndexer {
    private AttributeSet<Attribute> nodeAttributes = new AttributeSet();
    private AttributeSet<LinkAttribute> linkAttributes = new AttributeSet();
    private LinkDictionaryIndex linkIndex = new LinkDictionaryIndex(this);

    public AttributeNetwork() {
    }

    public AttributeNetwork(Network net) {
        this();
        this.setSize(net.size());
        int i = 0;
        while (i < net.size()) {
            int degree = net.outDegree(i);
            int j = 0;
            while (j < degree) {
                this.add(i, net.outLink(i, j));
                ++j;
            }
            ++i;
        }
    }

    @Override
    public boolean remove(int node) {
        int last = this.nodes() - 1;
        super.remove(node);
        int i = 0;
        while (i < this.nodeAttributes.size()) {
            Attribute attribute = this.nodeAttributes.get(i);
            attribute.set(node, attribute.get(last));
            attribute.remove(last);
            ++i;
        }
        i = 0;
        while (i < this.inDegree(last)) {
            this.redirect(this.inLink(last, i), last, this.inLink(last, i), node);
            ++i;
        }
        i = 0;
        while (i < this.outDegree(last)) {
            this.redirect(last, this.outLink(last, i), node, this.outLink(last, i));
            ++i;
        }
        return true;
    }

    @Override
    public boolean add(int source, int destination) {
        this.linkIndex.add(source, destination);
        return super.add(source, destination);
    }

    @Override
    public boolean remove(int source, int destination) {
        int position = this.linkIndex.remove(source, destination);
        if (position != -1) {
            int i = 0;
            while (i < this.linkAttributes.size()) {
                this.linkAttributes.get(i).remove(position);
                ++i;
            }
            return super.remove(source, destination);
        }
        return false;
    }

    private void redirect(int oldSource, int oldDestination, int newSource, int newDestination) {
        this.linkIndex.redirect(oldSource, oldDestination, newSource, newDestination);
    }

    @Override
    public int index(int source, int destination) {
        return this.linkIndex.index(source, destination);
    }

    @Override
    public int source(int index) {
        return this.linkIndex.source(index);
    }

    @Override
    public int destination(int index) {
        return this.linkIndex.destination(index);
    }

    public AttributeSet<Attribute> getNodeAttributes() {
        return this.nodeAttributes;
    }

    public int getNodeAttributeCount() {
        return this.nodeAttributes.size();
    }

    public Attribute getNodeAttribute(int index) {
        return this.nodeAttributes.get(index);
    }

    public Attribute getNodeAttribute(String id) {
        return this.nodeAttributes.get(id);
    }

    public void addNodeAttribute(Attribute attribute) {
        this.nodeAttributes.add(attribute);
    }

    public void removeNodeAttribute(String id) {
        this.nodeAttributes.remove(id);
    }

    public void setNodeAttribute(String id, int node, String value) {
        if (value != null) {
            Attribute attribute = this.getNodeAttribute(id);
            if (attribute == null) {
                attribute = id.equals("x") || id.equals("y") ? new Attribute(id, new RealModel()) : new Attribute(id);
                this.addNodeAttribute(attribute);
            }
            attribute.set(node, value);
        }
    }

    public AttributeSet<LinkAttribute> getLinkAttributes() {
        return this.linkAttributes;
    }

    public int getLinkAttributeCount() {
        return this.linkAttributes.size();
    }

    public LinkAttribute getLinkAttribute(int index) {
        return this.linkAttributes.get(index);
    }

    public LinkAttribute getLinkAttribute(String id) {
        return this.linkAttributes.get(id);
    }

    public void addLinkAttribute(LinkAttribute attribute) {
        this.linkAttributes.add(attribute);
    }

    public void removeLinkAttribute(String id) {
        this.linkAttributes.remove(id);
    }

    public void setLinkAttribute(String id, int source, int target, String value) {
        if (value != null) {
            LinkAttribute attribute = this.getLinkAttribute(id);
            if (attribute == null) {
                attribute = new LinkAttribute(this, id);
                this.addLinkAttribute(attribute);
            }
            attribute.set(source, target, value);
        }
    }
}

