/*
 * Decompiled with CFR 0.152.
 */
package noesis;

import noesis.Network;

public class BasicNetwork
extends Network<Integer, Integer> {
    private int size;
    private int nlinks;
    private int[][] inLinks;
    private int[][] outLinks;
    private static final int INITIAL_ARRAY_SIZE = 4;
    private static final int START_INDEX = 1;

    @Override
    public int nodes() {
        return this.size;
    }

    @Override
    public final void setSize(int size) {
        int oldSize = this.size;
        int[][] oldInLinks = this.inLinks;
        int[][] oldOutLinks = this.outLinks;
        this.size = size;
        this.inLinks = new int[size][];
        this.outLinks = new int[size][];
        if (oldInLinks != null) {
            System.arraycopy(oldInLinks, 0, this.inLinks, 0, oldSize);
        }
        if (oldOutLinks != null) {
            System.arraycopy(oldOutLinks, 0, this.outLinks, 0, oldSize);
        }
    }

    @Override
    public int links() {
        return this.nlinks;
    }

    @Override
    public final int add(Integer node) {
        int pos = node;
        if (pos >= this.size) {
            this.setSize(pos + 1);
        }
        return pos;
    }

    @Override
    public boolean remove(int node) {
        if (node >= 0 && node < this.size) {
            int i = this.inDegree(node) - 1;
            while (i >= 0) {
                this.remove(this.inLink(node, i), node);
                --i;
            }
            i = this.outDegree(node) - 1;
            while (i >= 0) {
                this.remove(node, this.outLink(node, i));
                --i;
            }
            this.inLinks[node] = this.inLinks[this.size - 1];
            this.outLinks[node] = this.outLinks[this.size - 1];
            --this.size;
            i = 0;
            while (i < this.inDegree(node)) {
                this.redirectOutLink(this.inLink(node, i), this.size, node);
                ++i;
            }
            i = 0;
            while (i < this.outDegree(node)) {
                this.redirectInLink(this.size, this.outLink(node, i), node);
                ++i;
            }
            return true;
        }
        return false;
    }

    private final int[] extend(int[] array, int value) {
        int[] newArray;
        if (array == null) {
            newArray = new int[4];
            newArray[0] = 1;
            newArray[1] = value;
        } else {
            int dim = array[0] + 1;
            if (dim < array.length) {
                newArray = array;
            } else {
                newArray = new int[2 * array.length];
                System.arraycopy(array, 0, newArray, 0, array.length);
            }
            newArray[0] = dim;
            newArray[dim] = value;
        }
        return newArray;
    }

    @Override
    public boolean add(int source, int destination) {
        if (source >= 0 && source < this.size() && destination >= 0 && destination < this.size() && !this.contains(source, destination)) {
            ++this.nlinks;
            this.outLinks[source] = this.extend(this.outLinks[source], destination);
            this.inLinks[destination] = this.extend(this.inLinks[destination], source);
            return true;
        }
        return false;
    }

    @Override
    public final boolean add(int sourceIndex, int destinationIndex, Integer value) {
        throw new UnsupportedOperationException("Unsupported operation on basic networks");
    }

    @Override
    public boolean remove(int source, int destination) {
        int indexOut = this.getOutLinkIndex(source, destination);
        int indexIn = this.getInLinkIndex(destination, source);
        if (indexOut != -1) {
            int i = indexOut;
            while (i < this.outDegree(source) - 1) {
                this.setOutLink(source, i, this.outLink(source, i + 1));
                ++i;
            }
            this.setOutDegree(source, this.outDegree(source) - 1);
            i = indexIn;
            while (i < this.inDegree(destination) - 1) {
                this.setInLink(destination, i, this.inLink(destination, i + 1));
                ++i;
            }
            this.setInDegree(destination, this.inDegree(destination) - 1);
            --this.nlinks;
            return true;
        }
        return false;
    }

    private void redirectOutLink(int source, int destination, int target) {
        int index = this.getOutLinkIndex(source, destination);
        if (index != -1) {
            this.setOutLink(source, index, target);
        }
    }

    private void redirectInLink(int source, int destination, int target) {
        int index = this.getInLinkIndex(destination, source);
        if (index != -1) {
            this.setInLink(destination, index, target);
        }
    }

    @Override
    public Integer get(int index) {
        return index;
    }

    @Override
    public void set(int index, Integer value) {
        throw new UnsupportedOperationException("Unsupported operation on basic networks");
    }

    public int getLinkIndex(int source, int destination) {
        return this.getOutLinkIndex(source, destination);
    }

    private int getOutLinkIndex(int source, int destination) {
        int i = 0;
        while (i < this.outDegree(source)) {
            if (this.outLink(source, i) == destination) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getInLinkIndex(int destination, int source) {
        int i = 0;
        while (i < this.inDegree(destination)) {
            if (this.inLink(destination, i) == source) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Integer get(int source, int destination) {
        if (this.outLinks[source] != null) {
            int i = 0;
            while (i < this.outLinks[source][0]) {
                if (this.outLink(source, i) == destination) {
                    return destination;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public boolean contains(int source, int destination) {
        if (this.outLinks[source] != null) {
            int i = 0;
            while (i < this.outLinks[source][0]) {
                if (this.outLink(source, i) == destination) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public boolean contains(Integer node) {
        return node >= 0 && node < this.size;
    }

    @Override
    public int index(Integer node) {
        return node;
    }

    @Override
    public int inDegree(int node) {
        if (this.inLinks != null && this.inLinks[node] != null) {
            return this.inLinks[node][0];
        }
        return 0;
    }

    private void setInDegree(int node, int degree) {
        if (this.inLinks != null && this.inLinks[node] != null) {
            this.inLinks[node][0] = degree;
        }
    }

    @Override
    public int outDegree(int node) {
        if (this.outLinks != null && this.outLinks[node] != null) {
            return this.outLinks[node][0];
        }
        return 0;
    }

    private void setOutDegree(int node, int degree) {
        if (this.outLinks != null && this.outLinks[node] != null) {
            this.outLinks[node][0] = degree;
        }
    }

    @Override
    public int outLink(int node, int index) {
        return this.outLinks[node][1 + index];
    }

    private void setOutLink(int node, int index, int destination) {
        this.outLinks[node][1 + index] = destination;
    }

    @Override
    public int inLink(int node, int index) {
        return this.inLinks[node][1 + index];
    }

    private void setInLink(int node, int index, int source) {
        this.inLinks[node][1 + index] = source;
    }

    @Override
    public String toString() {
        return "[" + super.toString() + "] " + this.size() + " nodes, " + this.links() + " links.";
    }
}

