/*
 * Decompiled with CFR 0.152.
 */
package noesis;

import ikor.collection.CollectionFactory;
import ikor.collection.Dictionary;
import ikor.collection.List;
import ikor.collection.index.Index;
import noesis.Network;

public class DynamicNetwork<V, E>
extends Network<V, E> {
    private List<V> nodes = CollectionFactory.createList();
    private Dictionary<V, Integer> index = CollectionFactory.createDictionary();
    private int currentNode = 0;
    private List<List<E>> content;
    private Index skip = CollectionFactory.createIndex();
    private List<Index> in = CollectionFactory.createList();
    private List<Index> out = CollectionFactory.createList();
    private int links = 0;

    public DynamicNetwork() {
    }

    public DynamicNetwork(Network<V, E> net) {
        this();
        int i = 0;
        while (i < net.size()) {
            this.add(net.get(i));
            ++i;
        }
        i = 0;
        while (i < net.size()) {
            int j = 0;
            while (j < net.outDegree(i)) {
                int target = net.outLink(i, j);
                this.add(i, target, net.get(i, target));
                ++j;
            }
            ++i;
        }
    }

    @Override
    public int nodes() {
        return this.skip.size();
    }

    @Override
    public void setSize(int nodes) {
        while (this.size() < nodes) {
            this.add((V)null);
        }
    }

    @Override
    public int links() {
        return this.links;
    }

    @Override
    public V get(int index) {
        return (V)this.nodes.get(this.skip.get(index));
    }

    @Override
    public void set(int index, V value) {
        this.nodes.set(this.skip.get(index), value);
    }

    @Override
    public int index(V node) {
        Integer entry = (Integer)this.index.get(node);
        if (entry != null) {
            return entry;
        }
        return -1;
    }

    @Override
    public E get(int source, int destination) {
        int sourceIndex = this.skip.get(source);
        int destinationIndex = this.skip.get(destination);
        if (this.content != null && sourceIndex >= 0 && sourceIndex < this.content.size()) {
            int index = ((Index)this.out.get(sourceIndex)).index(destinationIndex);
            if (index != -1) {
                return (E)((List)this.content.get(source)).get(index);
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean contains(int source, int destination) {
        int sourceIndex = this.skip.get(source);
        int destinationIndex = this.skip.get(destination);
        if (sourceIndex >= 0 && sourceIndex < this.size()) {
            int index = ((Index)this.out.get(sourceIndex)).index(destinationIndex);
            return index != -1;
        }
        return false;
    }

    @Override
    public int inDegree(int node) {
        int index = this.skip.get(node);
        Index inlinks = (Index)this.in.get(index);
        if (inlinks != null) {
            return inlinks.size();
        }
        return 0;
    }

    @Override
    public int outDegree(int node) {
        int index = this.skip.get(node);
        Index outlinks = (Index)this.out.get(index);
        if (outlinks != null) {
            return outlinks.size();
        }
        return 0;
    }

    @Override
    public int outLink(int node, int link) {
        int index = this.skip.get(node);
        return ((Index)this.out.get(index)).get(link);
    }

    @Override
    public int inLink(int node, int link) {
        int index = this.skip.get(node);
        return ((Index)this.in.get(index)).get(link);
    }

    @Override
    public int add(V node) {
        this.nodes.add(node);
        this.index.set((Integer)node, this.currentNode);
        this.skip.add(this.currentNode);
        this.in.add(CollectionFactory.createIndex());
        this.out.add(CollectionFactory.createIndex());
        ++this.currentNode;
        return this.size() - 1;
    }

    @Override
    public boolean remove(int nodeIndex) {
        if (nodeIndex >= 0 && nodeIndex < this.size()) {
            int[] outlink;
            int[] inlink = this.inLinks(nodeIndex);
            if (inlink != null) {
                int i = 0;
                while (i < inlink.length) {
                    this.remove(inlink[i], nodeIndex);
                    ++i;
                }
            }
            if ((outlink = this.outLinks(nodeIndex)) != null) {
                int j = 0;
                while (j < outlink.length) {
                    this.remove(nodeIndex, outlink[j]);
                    ++j;
                }
            }
            int pos = this.skip.get(nodeIndex);
            this.index.remove(this.nodes.get(pos));
            this.nodes.set(pos, null);
            this.skip.remove(pos);
            this.in.set(pos, null);
            this.out.set(pos, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean add(int sourceIndex, int destinationIndex) {
        int sourceNode = this.skip.get(sourceIndex);
        int destinationNode = this.skip.get(destinationIndex);
        ((Index)this.out.get(sourceNode)).add(destinationNode);
        ((Index)this.in.get(destinationNode)).add(sourceNode);
        ++this.links;
        return true;
    }

    @Override
    public boolean remove(int sourceIndex, int destinationIndex) {
        int sourceNode = this.skip.get(sourceIndex);
        int destinationNode = this.skip.get(destinationIndex);
        ((Index)this.out.get(sourceNode)).removeValue(destinationNode);
        ((Index)this.in.get(destinationNode)).removeValue(sourceNode);
        --this.links;
        return true;
    }

    @Override
    public boolean add(int sourceIndex, int destinationIndex, E value) {
        boolean ok = this.add(sourceIndex, destinationIndex);
        int sourceNode = this.skip.get(sourceIndex);
        if (ok) {
            if (this.content == null) {
                this.content = CollectionFactory.createList();
            }
            if (this.content.get(sourceNode) == null) {
                this.content.set(sourceNode, CollectionFactory.createList());
            }
            ((List)this.content.get(sourceNode)).add(value);
        }
        return ok;
    }

    @Override
    public boolean remove(int source, int destination, E value) {
        int sourceIndex = this.skip.get(source);
        int destinationIndex = this.skip.get(destination);
        this.remove(source, destination);
        if (this.content != null && this.content.get(sourceIndex) != null) {
            int index = ((Index)this.out.get(sourceIndex)).index(destinationIndex);
            ((List)this.content.get(sourceIndex)).set(index, null);
        }
        return true;
    }
}

