/*
 * Decompiled with CFR 0.152.
 */
package noesis;

import ikor.collection.graph.Graph;
import ikor.collection.graph.GraphLinkIterator;
import ikor.collection.graph.GraphNodeIterator;
import java.util.Iterator;

public abstract class Network<V, E>
implements Graph<V, E> {
    private String id;
    private boolean directed = true;

    public final String getID() {
        return this.id;
    }

    public final void setID(String id) {
        this.id = id;
    }

    @Override
    public final boolean isDirected() {
        return this.directed;
    }

    public final void setDirected(boolean directed) {
        this.directed = directed;
    }

    @Override
    public final int size() {
        return this.nodes();
    }

    public abstract int nodes();

    public abstract void setSize(int var1);

    @Override
    public abstract int links();

    @Override
    public abstract int index(V var1);

    @Override
    public abstract V get(int var1);

    @Override
    public abstract E get(int var1, int var2);

    @Override
    public final E get(V source, V destination) {
        int sourceIndex = this.index(source);
        int destinationIndex = this.index(destination);
        if (sourceIndex != -1 && destinationIndex != -1) {
            return this.get((V)sourceIndex, (V)destinationIndex);
        }
        return null;
    }

    @Override
    public boolean contains(V object) {
        return this.index(object) != -1;
    }

    public boolean contains(int source, int destination) {
        return this.get((V)source, (V)destination) != null;
    }

    @Override
    public final Iterator<V> iterator() {
        return new GraphNodeIterator(this);
    }

    public final Iterator<E> linkIterator() {
        return new GraphLinkIterator(this);
    }

    @Override
    public abstract int add(V var1);

    @Override
    public abstract void set(int var1, V var2);

    @Override
    public final boolean remove(V node) {
        return this.remove(this.index(node));
    }

    @Override
    public abstract boolean remove(int var1);

    public abstract boolean add(int var1, int var2);

    @Override
    public abstract boolean add(int var1, int var2, E var3);

    public final boolean add(V source, V destination) {
        int sourceIndex = this.index(source);
        int destinationIndex = this.index(destination);
        if (sourceIndex != -1 && destinationIndex != -1) {
            return this.add(sourceIndex, destinationIndex);
        }
        return false;
    }

    @Override
    public final boolean add(V source, V destination, E content) {
        int sourceIndex = this.index(source);
        int destinationIndex = this.index(destination);
        if (sourceIndex != -1 && destinationIndex != -1) {
            return this.add((V)sourceIndex, (V)destinationIndex, content);
        }
        return false;
    }

    public abstract boolean remove(int var1, int var2);

    @Override
    public boolean remove(int sourceIndex, int destinationIndex, E content) {
        throw new UnsupportedOperationException("Link removal is not allowed.");
    }

    public final boolean remove(V source, V destination) {
        int sourceIndex = this.index(source);
        int destinationIndex = this.index(destination);
        if (sourceIndex != -1 && destinationIndex != -1) {
            return this.remove(sourceIndex, destinationIndex);
        }
        return false;
    }

    @Override
    public final boolean remove(V source, V destination, E content) {
        int sourceIndex = this.index(source);
        int destinationIndex = this.index(destination);
        if (sourceIndex != -1 && destinationIndex != -1) {
            return this.remove((V)sourceIndex, (V)destinationIndex, content);
        }
        return false;
    }

    public final boolean add2(V source, V destination) {
        boolean ok = this.add(source, destination);
        if (ok) {
            ok = this.add(destination, source);
        }
        return ok;
    }

    public final boolean add2(V source, V destination, E content) {
        boolean ok = this.add(source, destination, content);
        if (ok) {
            ok = this.add(destination, source, content);
        }
        return ok;
    }

    public final boolean add2(int sourceIndex, int destinationIndex) {
        boolean ok = this.add(sourceIndex, destinationIndex);
        if (ok) {
            ok = this.add(destinationIndex, sourceIndex);
        }
        return ok;
    }

    public final boolean add2(int sourceIndex, int destinationIndex, E content) {
        boolean ok = this.add((V)sourceIndex, (V)destinationIndex, content);
        if (ok) {
            ok = this.add((V)destinationIndex, (V)sourceIndex, content);
        }
        return ok;
    }

    public final boolean remove2(V source, V destination) {
        boolean ok = this.remove(source, destination);
        if (ok) {
            ok = this.remove(destination, source);
        }
        return ok;
    }

    public final boolean remove2(V source, V destination, E content) {
        boolean ok = this.remove(source, destination, content);
        if (ok) {
            ok = this.remove(destination, source, content);
        }
        return ok;
    }

    public final boolean remove2(int sourceIndex, int destinationIndex) {
        boolean ok = false;
        if (this.contains(sourceIndex, destinationIndex)) {
            ok = this.remove(sourceIndex, destinationIndex);
        }
        if (ok && this.contains(destinationIndex, sourceIndex)) {
            ok = this.remove(destinationIndex, sourceIndex);
        }
        return ok;
    }

    public final boolean remove2(int sourceIndex, int destinationIndex, E content) {
        boolean ok = this.remove((V)sourceIndex, (V)destinationIndex, content);
        if (ok) {
            ok = this.remove((V)destinationIndex, (V)sourceIndex, content);
        }
        return ok;
    }

    @Override
    public void clear() {
        while (this.size() > 0) {
            this.remove(this.size() - 1);
        }
    }

    @Override
    public final int degree(int node) {
        return this.outDegree(node);
    }

    @Override
    public final int degree(V node) {
        return this.outDegree(node);
    }

    @Override
    public abstract int inDegree(int var1);

    @Override
    public final int inDegree(V node) {
        return this.inDegree(this.index(node));
    }

    @Override
    public abstract int outDegree(int var1);

    @Override
    public final int outDegree(V node) {
        return this.outDegree(this.index(node));
    }

    @Override
    public abstract int outLink(int var1, int var2);

    @Override
    public abstract int inLink(int var1, int var2);

    @Override
    public final int[] outLinks(V node) {
        return this.outLinks(this.index(node));
    }

    @Override
    public final int[] outLinks(int node) {
        int outDegree = this.outDegree(node);
        int[] links = null;
        if (outDegree > 0) {
            links = new int[outDegree];
            int i = 0;
            while (i < outDegree) {
                links[i] = this.outLink(node, i);
                ++i;
            }
        }
        return links;
    }

    @Override
    public final int[] inLinks(V node) {
        return this.inLinks(this.index(node));
    }

    @Override
    public final int[] inLinks(int node) {
        int inDegree = this.inDegree(node);
        int[] links = null;
        if (inDegree > 0) {
            links = new int[inDegree];
            int i = 0;
            while (i < inDegree) {
                links[i] = this.inLink(node, i);
                ++i;
            }
        }
        return links;
    }

    public String toString() {
        return String.valueOf(this.id != null ? this.id : "Network") + " (" + this.size() + " nodes, " + this.links() + " links)";
    }
}

