/*
 * Decompiled with CFR 0.152.
 */
package noesis;

import ikor.model.data.DataModel;
import ikor.model.data.IntegerModel;
import ikor.model.data.NumberModel;
import ikor.model.data.RealModel;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import ikor.util.log.Log;
import java.lang.reflect.Field;
import noesis.Parameter;

public class ParameterMetadata {
    private Field field;
    private String label;
    private String description;
    private NumberModel model;
    private double defaultValue;

    public ParameterMetadata(Field field) {
        this.field = field;
        if (field.getType().equals(Integer.class) || field.getType().equals(Integer.TYPE)) {
            this.setModel(new IntegerModel());
        } else if (field.getType().isAssignableFrom(Double.TYPE)) {
            this.setModel(new RealModel());
        } else {
            throw new IllegalArgumentException("Unsupported parameter type: " + field);
        }
        Parameter annotation = field.getAnnotation(Parameter.class);
        if (annotation != null) {
            this.setDefaultValue(annotation.defaultValue());
            this.setMinimumValue(annotation.min());
            this.setMaximumValue(annotation.max());
        }
        Label label = field.getAnnotation(Label.class);
        Description description = field.getAnnotation(Description.class);
        if (label != null) {
            this.setLabel(label.value());
        } else {
            this.setLabel(field.getName());
        }
        if (description != null) {
            this.setDescription(description.value());
        } else {
            this.setDescription(String.valueOf(this.getLabel()) + " parameter");
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DataModel getModel() {
        return this.model;
    }

    public void setModel(DataModel model) {
        this.model = (NumberModel)model;
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(double defaultValue) {
        this.defaultValue = defaultValue;
    }

    public double getMinimumValue() {
        if (this.model instanceof IntegerModel) {
            return ((Integer)this.model.getMinimumValue()).intValue();
        }
        return (Double)this.model.getMinimumValue();
    }

    public void setMinimumValue(double minimumValue) {
        if (this.model instanceof IntegerModel) {
            this.model.setMinimumValue((int)minimumValue);
        } else {
            this.model.setMinimumValue(minimumValue);
        }
    }

    public double getMaximumValue() {
        if (this.model instanceof IntegerModel) {
            return ((Integer)this.model.getMaximumValue()).intValue();
        }
        return (Double)this.model.getMaximumValue();
    }

    public void setMaximumValue(double maximumValue) {
        if (this.model instanceof IntegerModel) {
            this.model.setMaximumValue((int)maximumValue);
        } else {
            this.model.setMaximumValue(maximumValue);
        }
    }

    public void set(Object obj, double value) {
        try {
            this.field.setAccessible(true);
            if (this.model instanceof IntegerModel) {
                this.field.set(obj, (int)value);
            } else {
                this.field.set(obj, value);
            }
        }
        catch (IllegalAccessException error) {
            Log.error("Unable to set field " + this.field);
        }
    }
}

