/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.communities;

import ikor.math.DenseMatrix;
import ikor.math.DenseVector;
import ikor.math.Matrix;
import ikor.math.Vector;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.AttributeNetwork;
import noesis.Network;
import noesis.analysis.NodeScore;
import noesis.analysis.structure.communities.ModularityCoefficient;

@Label(value="CommunityDetector")
@Description(value="Community detection algorithm")
public abstract class CommunityDetector {
    protected AttributeNetwork network;
    protected Matrix results;

    public CommunityDetector(AttributeNetwork network) {
        this.network = network;
        this.results = new DenseMatrix(1, network.nodes(), -1.0);
    }

    public abstract void compute();

    public Matrix getResults() {
        return this.results;
    }

    public Vector getBest() {
        double bm = Double.NEGATIVE_INFINITY;
        DenseVector dv = new DenseVector(this.network.nodes());
        int k = 0;
        while (k < this.results.rows()) {
            NodeScore cl = new NodeScore("cluster assignment", (Network)this.network);
            cl.set(this.results.getRow(k));
            ModularityCoefficient mod = new ModularityCoefficient(this.network, cl);
            double m = mod.overallValue();
            if (m > bm) {
                bm = m;
                dv = new DenseVector(this.results.getRow(k));
            }
            ++k;
        }
        return dv;
    }
}

