/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.communities;

import ikor.math.Vector;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.AttributeNetwork;
import noesis.algorithms.communities.CommunityDetector;
import noesis.analysis.NodeScore;
import noesis.analysis.NodeScoreTask;

public class CommunityDetectorTask
extends NodeScoreTask {
    private CommunityDetector detector;
    private Vector best;

    public CommunityDetectorTask(CommunityDetector detector, AttributeNetwork network) {
        super(NodeScore.INTEGER_MODEL, network);
        this.detector = detector;
        this.best = null;
    }

    @Override
    public void compute() {
        this.detector.compute();
        this.best = this.detector.getBest();
        int size = this.getNetwork().size();
        NodeScore score = new NodeScore(this, this.getNetwork());
        int node = 0;
        while (node < size) {
            score.set(node, this.best.get(node));
            ++node;
        }
        this.setResult(score);
    }

    @Override
    public double compute(int node) {
        if (this.best == null) {
            this.compute();
        }
        return this.best.get(node);
    }

    @Override
    public String getName() {
        Class<?> type = this.detector.getClass();
        Label label = type.getAnnotation(Label.class);
        if (label != null) {
            return label.value();
        }
        return null;
    }

    @Override
    public String getDescription() {
        Class<?> type = this.detector.getClass();
        Description description = type.getAnnotation(Description.class);
        if (description != null) {
            return description.value();
        }
        return null;
    }
}

