/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.communities.hierarchical.agglomerative;

import ikor.collection.CollectionFactory;
import ikor.collection.List;
import ikor.math.DenseMatrix;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.AttributeNetwork;
import noesis.DynamicNetwork;
import noesis.algorithms.communities.CommunityDetector;
import noesis.algorithms.traversal.ConnectedComponents;
import noesis.analysis.NodeScore;
import noesis.analysis.structure.PathLength;

@Label(value="Agglomerative Algorithm")
@Description(value="Agglomerative Algorithm")
public abstract class AgglomerativeCommunityDetector
extends CommunityDetector {
    private DynamicNetwork dn = new DynamicNetwork();

    public AgglomerativeCommunityDetector(AttributeNetwork network) {
        super(network);
        this.results = new DenseMatrix(network.nodes(), network.nodes(), -1.0);
    }

    @Override
    public void compute() {
        int i;
        List lengths = CollectionFactory.createList();
        int node = 0;
        while (node < this.network.nodes()) {
            PathLength task = new PathLength(this.network, node);
            lengths.add((NodeScore)task.call());
            ++node;
        }
        this.dn = new DynamicNetwork();
        node = 0;
        while (node < this.network.nodes()) {
            this.dn.add(this.network.get(node));
            this.results.set(0, node, node);
            ++node;
        }
        ConnectedComponents cc = new ConnectedComponents(this.dn);
        cc.compute();
        boolean exit = false;
        int iter = 1;
        while (!exit && cc.components() > 1) {
            List clusters = CollectionFactory.createList();
            i = 0;
            while (i < cc.components()) {
                clusters.add(CollectionFactory.createList());
                ++i;
            }
            int node2 = 0;
            while (node2 < this.network.nodes()) {
                ((List)clusters.get(cc.component(node2) - 1)).add(node2);
                ++node2;
            }
            int c1 = 0;
            int c2 = 1;
            double dmin = 2.147483647E9;
            int i2 = 0;
            while (i2 < cc.components()) {
                int j = i2 + 1;
                while (j < cc.components()) {
                    double d = this.distance((List)clusters.get(i2), (List)clusters.get(j), lengths);
                    if (d < dmin) {
                        c1 = i2;
                        c2 = j;
                        dmin = d;
                    }
                    ++j;
                }
                ++i2;
            }
            List C1 = (List)clusters.get(c1);
            List C2 = (List)clusters.get(c2);
            exit = true;
            int i3 = 0;
            while (i3 < C1.size()) {
                int j = 0;
                while (j < C2.size()) {
                    if (this.network.index((Integer)C1.get(i3), (Integer)C2.get(j)) != -1) {
                        this.dn.add2(C1.get(i3), C2.get(j));
                        exit = false;
                    }
                    ++j;
                }
                ++i3;
            }
            if (exit) continue;
            cc = new ConnectedComponents(this.dn);
            cc.compute();
            i3 = 0;
            while (i3 < this.results.columns()) {
                this.results.set(iter, i3, cc.component(i3));
                ++i3;
            }
            ++iter;
        }
        DenseMatrix aux = new DenseMatrix(iter, this.network.nodes());
        i = 0;
        while (i < aux.rows()) {
            int j = 0;
            while (j < aux.columns()) {
                aux.set(i, j, this.results.get(i, j));
                ++j;
            }
            ++i;
        }
        this.results = new DenseMatrix(aux);
    }

    protected abstract double distance(List<Integer> var1, List<Integer> var2, List<NodeScore> var3);
}

