/*
 * Decompiled with CFR 0.152.
 */
package noesis.algorithms.communities.hierarchical.agglomerative;

import ikor.collection.List;
import ikor.model.data.annotations.Description;
import ikor.model.data.annotations.Label;
import noesis.AttributeNetwork;
import noesis.algorithms.communities.hierarchical.agglomerative.AgglomerativeCommunityDetector;
import noesis.analysis.NodeScore;

@Label(value="ALink")
@Description(value="Average-link hierarchical clustering")
public class AverageLinkCommunityDetector
extends AgglomerativeCommunityDetector {
    public AverageLinkCommunityDetector(AttributeNetwork network) {
        super(network);
    }

    @Override
    protected double distance(List<Integer> c1, List<Integer> c2, List<NodeScore> len) {
        double d = 0.0;
        double dav = 0.0;
        double s = c1.size() * c2.size();
        int i = 0;
        while (i < c1.size()) {
            int j = 0;
            while (j < c2.size()) {
                int node1 = (Integer)c1.get(i);
                int node2 = (Integer)c2.get(j);
                d = ((NodeScore)len.get(node1)).get(node2);
                d = d <= 0.0 ? 2.147483647E9 : d;
                dav += d / s;
                ++j;
            }
            ++i;
        }
        return dav;
    }
}

